/* --------------------------------------------------------------------------------------------
 * Copyright (c) Remy Suen. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.Util = exports.KEYWORDS = void 0;
exports.KEYWORDS = [
    "ADD",
    "ARG",
    "CMD",
    "COPY",
    "ENTRYPOINT",
    "ENV",
    "EXPOSE",
    "FROM",
    "HEALTHCHECK",
    "LABEL",
    "MAINTAINER",
    "ONBUILD",
    "RUN",
    "SHELL",
    "STOPSIGNAL",
    "USER",
    "VOLUME",
    "WORKDIR"
];
var Util = /** @class */ (function () {
    function Util() {
    }
    Util.isWhitespace = function (char) {
        return char === ' ' || char === '\t' || Util.isNewline(char);
    };
    Util.isNewline = function (char) {
        return char === '\r' || char === '\n';
    };
    /**
     * Determines if the given position is contained within the given range.
     *
     * @param position the position to check
     * @param range the range to see if the position is inside of
     */
    Util.isInsideRange = function (position, range) {
        if (range === null) {
            return false;
        }
        else if (range.start.line === range.end.line) {
            return range.start.line === position.line
                && range.start.character <= position.character
                && position.character <= range.end.character;
        }
        else if (range.start.line === position.line) {
            return range.start.character <= position.character;
        }
        else if (range.end.line === position.line) {
            return position.character <= range.end.character;
        }
        return range.start.line < position.line && position.line < range.end.line;
    };
    Util.isEmpty = function (range) {
        return range.start.line === range.end.line && range.start.character === range.end.character;
    };
    Util.rangeEquals = function (range, range2) {
        return Util.positionEquals(range.start, range2.start) && Util.positionEquals(range.end, range2.end);
    };
    Util.positionEquals = function (position, position2) {
        return position.line == position2.line && position.character === position2.character;
    };
    Util.positionBefore = function (origin, other) {
        if (origin.line < other.line) {
            return true;
        }
        else if (origin.line > other.line) {
            return false;
        }
        return origin.character < other.character;
    };
    return Util;
}());
exports.Util = Util;
