/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts;

import org.eclipse.linuxtools.internal.dataviewers.piechart.PieChart;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.AbstractChartWithoutAxisBuilder;
import org.eclipse.linuxtools.internal.systemtap.graphing.ui.charts.listeners.PieChartMouseMoveListener;
import org.eclipse.linuxtools.systemtap.graphing.core.adapters.IAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.Range;

public class PieChartBuilder
extends AbstractChartWithoutAxisBuilder {
    public static final String ID = "org.eclipse.linuxtools.systemtap.graphing.ui.charts.piechartbuilder";

    public PieChartBuilder(Composite parent, int style, String title, IAdapter adapter) {
        super(adapter, parent, style, title);
    }

    @Override
    protected void createChart() {
        this.chart = new PieChart((Composite)this, this.getStyle());
        ((PieChart)this.chart).setCustomColors(COLORS);
        this.chartMouseMoveListener = new PieChartMouseMoveListener((PieChart)this.chart, (Composite)this.chart);
    }

    @Override
    protected void buildXAxis() {
        String[] labels = this.adapter.getLabels();
        String[] seriesLabels = new String[labels.length - 1];
        for (int i = 0; i < seriesLabels.length; ++i) {
            seriesLabels[i] = labels[i + 1];
        }
        IAxis xAxis = this.chart.getAxisSet().getXAxis(0);
        xAxis.getTitle().setText(labels[0]);
        xAxis.setCategorySeries(seriesLabels);
    }

    @Override
    protected void buildXSeries() {
        Object[][] data = this.adapter.getData();
        if (data == null || data.length == 0) {
            return;
        }
        int start = 0;
        int len = Math.min(this.maxItems, data.length);
        int leny = data[0].length - 1;
        if (this.maxItems < data.length) {
            start = data.length - this.maxItems;
        }
        Double[][] all_values = new Double[len][leny];
        String[] all_labels = new String[len];
        for (int i = 0; i < all_labels.length; ++i) {
            Object label = data[start + i][0];
            if (label == null) continue;
            all_labels[i] = label.toString();
            for (int j = 1; j < data[start + i].length; ++j) {
                Double val = this.getDoubleOrNullValue(data[start + i][j]);
                all_values[i][j - 1] = val != null && val >= 0.0 ? val : Double.valueOf(0.0);
            }
        }
        double[][] values = new double[len][leny];
        String[] labels = new String[len];
        int len_trim = 0;
        for (int i = 0; i < len; ++i) {
            if (all_labels[i] == null) continue;
            labels[len_trim] = all_labels[i];
            for (int j = 0; j < leny; ++j) {
                values[len_trim][j] = all_values[i][j];
            }
            ++len_trim;
        }
        double[][] values_trim = new double[len_trim][leny];
        String[] labels_trim = new String[len_trim];
        for (int i = 0; i < len_trim; ++i) {
            labels_trim[i] = labels[i];
            for (int j = 0; j < leny; ++j) {
                values_trim[i][j] = values[i][j];
            }
        }
        ((PieChart)this.chart).addPieChartSeries(this.getUniqueNames(labels_trim), values_trim);
        this.applyCategoryRange(values_trim[0].length);
        this.chart.redraw();
    }

    private void applyCategoryRange(int numItems) {
        int itemRange = Math.max(1, (int)Math.ceil((double)numItems * this.scale));
        int lower = (int)Math.round((double)(numItems - itemRange) * this.scroll);
        this.chart.getAxisSet().getXAxis(0).setRange(new Range((double)lower, (double)(lower + itemRange - 1)));
    }

    @Override
    public void updateDataSet() {
        this.buildXSeries();
        this.chartMouseMoveListener.update();
    }

    @Override
    protected void buildYAxis() {
    }

    @Override
    protected void buildYSeries() {
    }
}

