/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.support;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.etrice.ui.behavior.fsm.dialogs.QuickFixDialog;
import org.eclipse.etrice.ui.behavior.fsm.editor.AbstractFSMEditor;
import org.eclipse.etrice.ui.behavior.fsm.provider.IInjectorProvider;
import org.eclipse.etrice.ui.behavior.fsm.support.IBehaviorQuickfixProvider;
import org.eclipse.etrice.ui.common.base.quickfix.IssueResolution;
import org.eclipse.etrice.ui.common.base.support.ChangeAwareCustomFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;

public class QuickFixFeature
extends ChangeAwareCustomFeature {
    private HashMap<FeatureBasedDiagnostic, List<IssueResolution>> issueResolutionsMap;

    public QuickFixFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return "Quick Fix";
    }

    public String getDescription() {
        return "Apply Quick fixes";
    }

    public String getImageId() {
        return "org.eclipse.etrice.ui.behavior.quickfix";
    }

    public boolean canExecute(ICustomContext context) {
        Object bo = this.getBusinessObject(context);
        this.computeResolutions(bo);
        return !this.issueResolutionsMap.isEmpty();
    }

    public boolean doExecute(ICustomContext context) {
        Object[] result;
        Object bo = this.getBusinessObject(context);
        this.computeResolutions(bo);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        QuickFixDialog dlg = new QuickFixDialog(shell, this.issueResolutionsMap);
        if (dlg.open() == 0 && (result = dlg.getResult()) != null) {
            return ((IssueResolution)result[0]).apply(this.getDiagram(), this.getFeatureProvider());
        }
        return false;
    }

    private Object getBusinessObject(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe = pes[0];
            if (pe instanceof ConnectionDecorator) {
                pe = (PictogramElement)pe.eContainer();
            }
            return this.getBusinessObjectForPictogramElement(pe);
        }
        return null;
    }

    private void computeResolutions(Object bo) {
        if (this.issueResolutionsMap == null) {
            ArrayList<Diagnostic> issues = ((AbstractFSMEditor)this.getDiagramBehavior().getDiagramContainer()).getDiagnosingModelObserver().getElementDiagonsticMap().get(bo);
            this.issueResolutionsMap = new HashMap();
            Injector injector = ((IInjectorProvider)this.getFeatureProvider()).getInjector();
            IBehaviorQuickfixProvider behaviorQuickfixProvider = (IBehaviorQuickfixProvider)injector.getInstance(IBehaviorQuickfixProvider.class);
            for (Diagnostic issue : issues) {
                if (((FeatureBasedDiagnostic)issue).getIssueCode() == null) continue;
                this.issueResolutionsMap.put((FeatureBasedDiagnostic)issue, behaviorQuickfixProvider.getResolutions((FeatureBasedDiagnostic)issue));
            }
        }
    }
}

