/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cssparser.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSCharsetRuleImpl;
import org.htmlunit.cssparser.dom.CSSFontFaceRuleImpl;
import org.htmlunit.cssparser.dom.CSSImportRuleImpl;
import org.htmlunit.cssparser.dom.CSSMediaRuleImpl;
import org.htmlunit.cssparser.dom.CSSPageRuleImpl;
import org.htmlunit.cssparser.dom.CSSRuleListImpl;
import org.htmlunit.cssparser.dom.CSSStyleDeclarationImpl;
import org.htmlunit.cssparser.dom.CSSStyleRuleImpl;
import org.htmlunit.cssparser.dom.CSSStyleSheetImpl;
import org.htmlunit.cssparser.dom.CSSUnknownRuleImpl;
import org.htmlunit.cssparser.dom.CSSValueImpl;
import org.htmlunit.cssparser.dom.MediaListImpl;
import org.htmlunit.cssparser.dom.Property;
import org.htmlunit.cssparser.parser.AbstractCSSParser;
import org.htmlunit.cssparser.parser.CSSErrorHandler;
import org.htmlunit.cssparser.parser.CSSException;
import org.htmlunit.cssparser.parser.DocumentHandler;
import org.htmlunit.cssparser.parser.HandlerBase;
import org.htmlunit.cssparser.parser.InputSource;
import org.htmlunit.cssparser.parser.LexicalUnit;
import org.htmlunit.cssparser.parser.Locator;
import org.htmlunit.cssparser.parser.javacc.CSS3Parser;
import org.htmlunit.cssparser.parser.media.MediaQueryList;
import org.htmlunit.cssparser.parser.selector.SelectorList;
import org.w3c.dom.DOMException;

public class CSSOMParser {
    private final AbstractCSSParser parser_;
    private CSSStyleSheetImpl parentStyleSheet_;

    public CSSOMParser(AbstractCSSParser parser) {
        this.parser_ = parser;
    }

    public CSSOMParser() {
        this.parser_ = new CSS3Parser();
    }

    public void setErrorHandler(CSSErrorHandler eh) {
        this.parser_.setErrorHandler(eh);
    }

    public CSSStyleSheetImpl parseStyleSheet(InputSource source, String href) throws IOException {
        CSSOMHandler handler = new CSSOMHandler();
        handler.setHref(href);
        this.parser_.setDocumentHandler(handler);
        this.parser_.parseStyleSheet(source);
        Object o = handler.getRoot();
        if (o instanceof CSSStyleSheetImpl) {
            return (CSSStyleSheetImpl)o;
        }
        return null;
    }

    public CSSStyleDeclarationImpl parseStyleDeclaration(String styleDecl) throws IOException {
        CSSStyleDeclarationImpl sd = new CSSStyleDeclarationImpl(null);
        this.parseStyleDeclaration(sd, styleDecl);
        return sd;
    }

    public void parseStyleDeclaration(CSSStyleDeclarationImpl sd, String styleDecl) throws IOException {
        try (InputSource source = new InputSource(new StringReader(styleDecl));){
            ArrayDeque<Object> nodeStack = new ArrayDeque<Object>();
            nodeStack.push(sd);
            CSSOMHandler handler = new CSSOMHandler(nodeStack);
            this.parser_.setDocumentHandler(handler);
            this.parser_.parseStyleDeclaration(source);
        }
    }

    public CSSValueImpl parsePropertyValue(String propertyValue) throws IOException {
        try (InputSource source = new InputSource(new StringReader(propertyValue));){
            CSSOMHandler handler = new CSSOMHandler();
            this.parser_.setDocumentHandler(handler);
            LexicalUnit lu = this.parser_.parsePropertyValue(source);
            if (null == lu) {
                CSSValueImpl cSSValueImpl = null;
                return cSSValueImpl;
            }
            CSSValueImpl cSSValueImpl = new CSSValueImpl(lu);
            return cSSValueImpl;
        }
    }

    public AbstractCSSRuleImpl parseRule(String rule) throws IOException {
        try (InputSource source = new InputSource(new StringReader(rule));){
            CSSOMHandler handler = new CSSOMHandler();
            this.parser_.setDocumentHandler(handler);
            this.parser_.parseRule(source);
            AbstractCSSRuleImpl abstractCSSRuleImpl = (AbstractCSSRuleImpl)handler.getRoot();
            return abstractCSSRuleImpl;
        }
    }

    public SelectorList parseSelectors(String selectors) throws IOException {
        try (InputSource source = new InputSource(new StringReader(selectors));){
            HandlerBase handler = new HandlerBase();
            this.parser_.setDocumentHandler(handler);
            SelectorList selectorList = this.parser_.parseSelectors(source);
            return selectorList;
        }
    }

    public MediaQueryList parseMedia(String media) throws IOException {
        try (InputSource source = new InputSource(new StringReader(media));){
            HandlerBase handler = new HandlerBase();
            this.parser_.setDocumentHandler(handler);
            MediaQueryList mediaQueryList = this.parser_.parseMedia(source);
            return mediaQueryList;
        }
    }

    public void setParentStyleSheet(CSSStyleSheetImpl parentStyleSheet) {
        this.parentStyleSheet_ = parentStyleSheet;
    }

    protected CSSStyleSheetImpl getParentStyleSheet() {
        return this.parentStyleSheet_;
    }

    class CSSOMHandler
    implements DocumentHandler {
        private final Deque<Object> nodeStack_;
        private Object root_;
        private String href_;

        private String getHref() {
            return this.href_;
        }

        private void setHref(String href) {
            this.href_ = href;
        }

        CSSOMHandler(Deque<Object> nodeStack) {
            this.nodeStack_ = nodeStack;
        }

        CSSOMHandler() {
            this.nodeStack_ = new ArrayDeque<Object>();
        }

        Object getRoot() {
            return this.root_;
        }

        @Override
        public void startDocument(InputSource source) throws CSSException {
            if (this.nodeStack_.isEmpty()) {
                CSSStyleSheetImpl ss = new CSSStyleSheetImpl();
                CSSOMParser.this.setParentStyleSheet(ss);
                ss.setHref(this.getHref());
                ss.setMediaText(source.getMedia());
                ss.setTitle(source.getTitle());
                CSSRuleListImpl rules = new CSSRuleListImpl();
                ss.setCssRules(rules);
                this.nodeStack_.push(ss);
                this.nodeStack_.push(rules);
            }
        }

        @Override
        public void endDocument(InputSource source) throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        @Override
        public void ignorableAtRule(String atRule, Locator locator) throws CSSException {
            CSSUnknownRuleImpl ir = new CSSUnknownRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), atRule);
            ir.setLocator(locator);
            if (!this.nodeStack_.isEmpty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(ir);
            } else {
                this.root_ = ir;
            }
        }

        @Override
        public void charset(String characterEncoding, Locator locator) throws CSSException {
            CSSCharsetRuleImpl cr = new CSSCharsetRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), characterEncoding);
            cr.setLocator(locator);
            if (!this.nodeStack_.isEmpty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(cr);
            } else {
                this.root_ = cr;
            }
        }

        @Override
        public void importStyle(String uri, MediaQueryList media, String defaultNamespaceURI, Locator locator) throws CSSException {
            CSSImportRuleImpl ir = new CSSImportRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), uri, new MediaListImpl(media));
            ir.setLocator(locator);
            if (!this.nodeStack_.isEmpty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(ir);
            } else {
                this.root_ = ir;
            }
        }

        @Override
        public void startMedia(MediaQueryList media, Locator locator) throws CSSException {
            MediaListImpl ml = new MediaListImpl(media);
            CSSMediaRuleImpl mr = new CSSMediaRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), ml);
            mr.setLocator(locator);
            if (!this.nodeStack_.isEmpty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(mr);
            }
            CSSRuleListImpl rules = new CSSRuleListImpl();
            mr.setRuleList(rules);
            this.nodeStack_.push(mr);
            this.nodeStack_.push(rules);
        }

        @Override
        public void endMedia(MediaQueryList media) throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        @Override
        public void startPage(String name, String pseudoPage, Locator locator) throws CSSException {
            CSSPageRuleImpl pr = new CSSPageRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), pseudoPage);
            pr.setLocator(locator);
            if (!this.nodeStack_.isEmpty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(pr);
            }
            CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(pr);
            pr.setStyle(decl);
            this.nodeStack_.push(pr);
            this.nodeStack_.push(decl);
        }

        @Override
        public void endPage(String name, String pseudoPage) throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        @Override
        public void startFontFace(Locator locator) throws CSSException {
            CSSFontFaceRuleImpl ffr = new CSSFontFaceRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule());
            ffr.setLocator(locator);
            if (!this.nodeStack_.isEmpty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(ffr);
            }
            CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(ffr);
            ffr.setStyle(decl);
            this.nodeStack_.push(ffr);
            this.nodeStack_.push(decl);
        }

        @Override
        public void endFontFace() throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        @Override
        public void startSelector(SelectorList selectors, Locator locator) throws CSSException {
            CSSStyleRuleImpl sr = new CSSStyleRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), selectors);
            sr.setLocator(locator);
            if (!this.nodeStack_.isEmpty()) {
                Object o = this.nodeStack_.peek();
                ((CSSRuleListImpl)o).add(sr);
            }
            CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(sr);
            sr.setStyle(decl);
            this.nodeStack_.push(sr);
            this.nodeStack_.push(decl);
        }

        @Override
        public void endSelector(SelectorList selectors) throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important, Locator locator) {
            CSSStyleDeclarationImpl decl = (CSSStyleDeclarationImpl)this.nodeStack_.peek();
            try {
                Property property = new Property(name, new CSSValueImpl(value), important);
                property.setLocator(locator);
                decl.addProperty(property);
            }
            catch (DOMException e) {
                CSSOMParser.this.parser_.getErrorHandler().error(CSSOMParser.this.parser_.toCSSParseException(e));
            }
        }

        private AbstractCSSRuleImpl getParentRule() {
            if (!this.nodeStack_.isEmpty() && this.nodeStack_.size() > 1) {
                Iterator<Object> iter = this.nodeStack_.iterator();
                iter.next();
                Object node = iter.next();
                if (node instanceof AbstractCSSRuleImpl) {
                    return (AbstractCSSRuleImpl)node;
                }
            }
            return null;
        }
    }
}

