/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.rdf.emf;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.collections.collection.UnmodifiableCollection;
import org.apache.commons.collections.map.UnmodifiableMap;
import org.apache.commons.collections.set.UnmodifiableSet;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Bag;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.RDFVisitor;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Seq;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class RDFDeserializer {
    private final Supplier<EPackage.Registry> packageRegistry;
    private final Map<EObject, Resource> eobToResource = new IdentityHashMap<EObject, Resource>();
    private final Multimap<Resource, EObject> resourceToEob = HashMultimap.create();
    private final Map<EObject, Resource> deregisteredEObject = new IdentityHashMap<EObject, Resource>();

    public RDFDeserializer(Supplier<EPackage.Registry> packageRegistry) {
        this.packageRegistry = packageRegistry;
    }

    public String normaliseEPackageNSURI(String namespaceURI) {
        if (!((String)namespaceURI).endsWith("#") && !((String)namespaceURI).endsWith("/")) {
            namespaceURI = (String)namespaceURI + "#";
        }
        return namespaceURI;
    }

    public void deserialize(Model model) {
        ResIterator it = model.listResourcesWithProperty(RDF.type);
        while (it.hasNext()) {
            Resource res = (Resource)it.next();
            if (res.isAnon()) continue;
            this.deserializeObjectAttributes(res);
        }
        for (Map.Entry entry : this.resourceToEob.entries()) {
            this.deserializeObjectReferences((Resource)entry.getKey(), (EObject)entry.getValue());
        }
    }

    public Resource getRDFResource(EObject eob) {
        return this.eobToResource.get(eob);
    }

    public Collection<EObject> getEObjects(Resource res) {
        return UnmodifiableCollection.decorate((Collection)this.resourceToEob.get((Object)res));
    }

    public Map<EObject, Resource> getEObjectToResourceMap() {
        return UnmodifiableMap.decorate(this.eobToResource);
    }

    public Collection<Resource> getRDFResources() {
        return UnmodifiableSet.decorate((Set)this.resourceToEob.keySet());
    }

    protected EObject deserializeObjectAttributes(Resource node, EClass eClass) {
        EObject eob = eClass.getEPackage().getEFactoryInstance().create(eClass);
        this.eobToResource.put(eob, node);
        this.resourceToEob.put((Object)node, (Object)eob);
        for (EAttribute sf : eClass.getEAllAttributes()) {
            if (sf.isDerived() || sf.isTransient()) continue;
            this.deserializeProperty(node, eob, (EStructuralFeature)sf);
        }
        return eob;
    }

    protected void deserializeObjectReferences(Resource resource, EObject eob) {
        for (EReference eRef : eob.eClass().getEAllReferences()) {
            if (eRef.isDerived() || eRef.isTransient()) continue;
            this.deserializeProperty(resource, eob, (EStructuralFeature)eRef);
        }
    }

    protected void deserializeProperty(Resource node, EObject eob, EStructuralFeature sf) {
        Object value = this.deserializeProperty(node, sf);
        if (!(value instanceof Collection)) {
            eob.eSet(sf, value);
            return;
        }
        ((EList)eob.eGet(sf)).addAll((Collection)value);
    }

    protected Object deserializeProperty(Resource node, EStructuralFeature sf) {
        String sfPackageURI = this.normaliseEPackageNSURI(sf.getEContainingClass().getEPackage().getNsURI());
        ArrayList<Object> values = new ArrayList<Object>();
        StmtIterator itValue = node.listProperties((Property)new PropertyImpl(sfPackageURI, sf.getName()));
        while (itValue.hasNext()) {
            Statement stmt = (Statement)itValue.next();
            Object deserialized = this.deserializeValue(stmt.getObject(), sf);
            if (deserialized instanceof Collection) {
                values.addAll((Collection)deserialized);
                continue;
            }
            if (deserialized == null) continue;
            values.add(deserialized);
        }
        if (sf.isMany()) {
            return values;
        }
        if (values.isEmpty()) {
            return null;
        }
        return values.iterator().next();
    }

    protected Object deserializeValue(RDFNode node, final EStructuralFeature sf) {
        Object value = node.visitWith(new RDFVisitor(){

            private Collection<?> createCollectionOfMultiValues(ExtendedIterator<RDFNode> i) {
                ArrayList values = new ArrayList();
                i.forEach(n -> {
                    Object newValue = RDFDeserializer.this.deserializeValue((RDFNode)n, sf);
                    if (newValue != null) {
                        values.add(newValue);
                    }
                });
                return values;
            }

            public Object visitBlank(Resource r, AnonId id) {
                if (r.hasProperty(RDF.type, (RDFNode)RDF.List)) {
                    RDFList list = (RDFList)r.as(RDFList.class);
                    return this.createCollectionOfMultiValues((ExtendedIterator<RDFNode>)list.iterator());
                }
                if (r.hasProperty(RDF.type, (RDFNode)RDF.Bag)) {
                    Bag bag = (Bag)r.as(Bag.class);
                    return this.createCollectionOfMultiValues((ExtendedIterator<RDFNode>)bag.iterator());
                }
                if (r.hasProperty(RDF.type, (RDFNode)RDF.Seq)) {
                    Seq seq = (Seq)r.as(Seq.class);
                    return this.createCollectionOfMultiValues((ExtendedIterator<RDFNode>)seq.iterator());
                }
                return null;
            }

            public Object visitURI(Resource r, String uri) {
                Collection potentialTargets = RDFDeserializer.this.resourceToEob.get((Object)r);
                for (EObject target : potentialTargets) {
                    if (!sf.getEType().isInstance((Object)target)) continue;
                    return target;
                }
                return null;
            }

            public Object visitLiteral(Literal l) {
                Class type = l.getDatatype().getJavaClass();
                if (type == Byte.class) {
                    return l.getByte();
                }
                if (type == Long.class) {
                    return l.getLong();
                }
                if (type == Short.class) {
                    return l.getShort();
                }
                if (type == XSDDateTime.class) {
                    return ((XSDDateTime)l.getValue()).asCalendar().getTime();
                }
                if (sf.getEType().equals(EcorePackage.eINSTANCE.getEChar()) || sf.getEType().equals(EcorePackage.eINSTANCE.getECharacterObject())) {
                    return Character.valueOf(l.getString().charAt(0));
                }
                return l.getValue();
            }
        });
        return value;
    }

    protected Set<EClass> findMostSpecificEClasses(Resource node) {
        HashSet<EClass> eClasses = new HashSet<EClass>();
        StmtIterator it = node.listProperties(RDF.type);
        while (it.hasNext()) {
            RDFNode typeObject = ((Statement)it.next()).getObject();
            if (typeObject.isAnon()) continue;
            String nsURI = typeObject.asResource().getNameSpace();
            String typeName = typeObject.asResource().getLocalName();
            EPackage ePackage = this.packageRegistry.get().getEPackage(nsURI);
            if (ePackage == null && (nsURI.endsWith("#") || nsURI.endsWith("/"))) {
                ePackage = this.packageRegistry.get().getEPackage(nsURI.substring(0, nsURI.length() - 1));
            }
            if (ePackage == null) continue;
            EClassifier eClassifier = ePackage.getEClassifier(typeName);
            if (eClassifier == null) {
                System.err.println(String.format("Cannot find type '%s' in EPackage with nsURI '%s'", typeName, nsURI));
            }
            if (!(eClassifier instanceof EClass)) continue;
            EClass newEClass = (EClass)eClassifier;
            boolean isSuperTypeOfExisting = eClasses.stream().filter(existing -> newEClass.isSuperTypeOf(existing)).findFirst().isPresent();
            if (isSuperTypeOfExisting) continue;
            Iterator itEClass = eClasses.iterator();
            while (itEClass.hasNext()) {
                EClass existingEClass = (EClass)itEClass.next();
                if (!existingEClass.isSuperTypeOf(newEClass)) continue;
                itEClass.remove();
            }
            eClasses.add(newEClass);
        }
        return eClasses;
    }

    protected void deserializeObjectAttributes(Resource node) {
        Set<EClass> eClasses = this.findMostSpecificEClasses(node);
        for (EClass eClass : eClasses) {
            EObject eob = this.deserializeObjectAttributes(node, eClass);
            this.eobToResource.put(eob, node);
            this.resourceToEob.put((Object)node, (Object)eob);
        }
    }

    public void deregisterEObject(EObject eob) {
        Resource node = this.getRDFResource(eob);
        this.eobToResource.remove(eob);
        this.resourceToEob.remove((Object)eob, (Object)node);
        this.deregisteredEObject.put(eob, node);
    }

    public void registerNewEObject(EObject eob, Resource node) {
        this.eobToResource.put(eob, node);
        this.resourceToEob.put((Object)node, (Object)eob);
    }

    public Resource restoreEObjectResource(EObject eObject) {
        Resource node = this.deregisteredEObject.remove(eObject);
        if (node != null) {
            this.registerNewEObject(eObject, node);
        }
        return node;
    }
}

