/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpFilter
extends Op1 {
    protected ExprList expressions;

    public static Op filter(Expr expr, Op op) {
        OpFilter f = OpFilter.ensureFilter(op);
        f.getExprs().add(expr);
        return f;
    }

    public static OpFilter ensureFilter(Op op) {
        if (op instanceof OpFilter) {
            return (OpFilter)op;
        }
        return new OpFilter(op);
    }

    public static Op filterBy(ExprList exprs, Op op) {
        if (exprs == null || exprs.isEmpty()) {
            return op;
        }
        OpFilter f = OpFilter.ensureFilter(op);
        f.getExprs().addAll(exprs);
        return f;
    }

    public static OpFilter filterAlways(ExprList exprs, Op subOp) {
        OpFilter f = OpFilter.ensureFilter(subOp);
        f.getExprs().addAll(exprs);
        return f;
    }

    public static OpFilter filterDirect(ExprList exprs, Op op) {
        return new OpFilter(exprs, op);
    }

    public static OpFilter filterDirect(Expr expr, Op op) {
        OpFilter f = new OpFilter(op);
        f.getExprs().add(expr);
        return f;
    }

    private OpFilter(Op sub) {
        super(sub);
        this.expressions = new ExprList();
    }

    private OpFilter(ExprList exprs, Op sub) {
        super(sub);
        this.expressions = exprs;
    }

    public static OpFilter tidy(OpFilter base) {
        ExprList exprs = new ExprList();
        Op op = base;
        while (op instanceof OpFilter) {
            OpFilter f = op;
            exprs.addAll(f.getExprs());
            op = f.getSubOp();
        }
        return new OpFilter(exprs, op);
    }

    public ExprList getExprs() {
        return this.expressions;
    }

    @Override
    public String getName() {
        return "filter";
    }

    @Override
    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op1 copy(Op subOp) {
        return new OpFilter(this.expressions, subOp);
    }

    @Override
    public int hashCode() {
        return this.expressions.hashCode();
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpFilter)) {
            return false;
        }
        OpFilter opFilter = (OpFilter)other;
        if (!this.expressions.equals(opFilter.expressions)) {
            return false;
        }
        return this.getSubOp().equalTo(opFilter.getSubOp(), labelMap);
    }
}

