/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecore.delegates.notify;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epsilon.ecore.delegates.notify.Adapters;
import org.eclipse.epsilon.ecore.delegates.notify.DelegateEPackageAdapter;

public class DelegateResourceAdapter
extends AdapterImpl {
    private final Adapters adapters;

    public DelegateResourceAdapter(Adapters adapters) {
        this.adapters = adapters;
    }

    public Resource getTarget() {
        return (Resource)super.getTarget();
    }

    public boolean isAdapterForType(Object type) {
        return type == DelegateResourceAdapter.class;
    }

    public void notifyChanged(Notification notification) {
        int featureID = notification.getFeatureID(Resource.class);
        int eventType = notification.getEventType();
        if (featureID == 4) {
            if (eventType == 1) {
                Resource resource = this.getTarget();
                EList contents = resource.getContents();
                if (notification.getNewBooleanValue()) {
                    EPackage.Registry packageRegistry = resource.getResourceSet().getPackageRegistry();
                    this.installPackages(packageRegistry, (List<? extends EObject>)contents);
                }
            }
        } else if (featureID == 2) {
            if (eventType == 4) {
                this.unloadDelegate((EObject)notification.getOldValue());
            } else if (eventType == 6) {
                List oldValue = (List)notification.getOldValue();
                this.unloadDelegates(oldValue);
            }
        }
    }

    public void setTarget(Notifier newTarget) {
        Resource resource = (Resource)newTarget;
        super.setTarget((Notifier)resource);
    }

    public void adapt(Resource resource) {
        DelegateResourceAdapter adapter = (DelegateResourceAdapter)EcoreUtil.getAdapter((List)resource.eAdapters(), DelegateResourceAdapter.class);
        if (adapter == null) {
            resource.eAdapters().add((Object)this);
        }
    }

    protected void installPackages(EPackage.Registry packageRegistry, List<? extends EObject> contents) {
        for (EObject eObject : contents) {
            if (!(eObject instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)eObject;
            packageRegistry.put((Object)ePackage.getNsURI(), (Object)ePackage);
            this.installPackages(packageRegistry, (List<? extends EObject>)ePackage.getESubpackages());
        }
    }

    protected void unloadDelegate(EObject eObject) {
        Resource resource;
        if (eObject instanceof EPackage) {
            EPackage ePackage = (EPackage)eObject;
            DelegateEPackageAdapter adapter = this.adapters.findAdapter(ePackage);
            if (adapter != null) {
                adapter.unloadDelegates();
            }
            this.unloadDelegates((List<? extends EObject>)ePackage.getESubpackages());
        }
        if ((resource = this.getTarget()) != null) {
            resource.eAdapters().remove((Object)this);
        }
    }

    protected void unloadDelegates(List<? extends EObject> contents) {
        for (EObject eObject : contents) {
            this.unloadDelegate(eObject);
        }
    }
}

