/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_addFileContentsToTheIndex")
class Add
extends TextBuiltin {
    @Option(name="--renormalize", usage="usage_addRenormalize")
    private boolean renormalize = false;
    @Option(name="--update", aliases={"-u"}, usage="usage_onlyMatchAgainstAlreadyTrackedFiles")
    private boolean update = false;
    @Option(name="--all", aliases={"-A", "--no-ignore-removal"}, usage="usage_addStageDeletions")
    private Boolean all;
    @Argument(metaVar="metaVar_filepattern", usage="usage_filesToAddContentFrom")
    private List<String> filepatterns = new ArrayList<String>();

    Add() {
    }

    @Option(name="--no-all", aliases={"--ignore-removal"}, usage="usage_addDontStageDeletions")
    private void noAll(boolean ignored) {
        this.all = Boolean.FALSE;
    }

    @Override
    protected void run() throws Exception {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Git git = new Git(this.db);){
                if (this.renormalize) {
                    this.update = true;
                }
                if (this.update && this.all != null) {
                    throw Add.die(CLIText.get().addIncompatibleOptions);
                }
                AddCommand addCmd = git.add();
                addCmd.setUpdate(this.update).setRenormalize(this.renormalize);
                if (this.all != null) {
                    addCmd.setAll(this.all.booleanValue());
                }
                for (String p : this.filepatterns) {
                    addCmd.addFilepattern(p);
                }
                addCmd.call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException e) {
            throw Add.die(e.getMessage(), (Throwable)e);
        }
    }
}

