/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.lifecycle;

import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import jakarta.mvc.engine.ViewEngine;
import jakarta.mvc.event.AfterControllerEvent;
import jakarta.mvc.event.AfterProcessViewEvent;
import jakarta.mvc.event.BeforeControllerEvent;
import jakarta.mvc.event.BeforeProcessViewEvent;
import jakarta.mvc.event.MvcEvent;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.UriInfo;
import org.eclipse.krazo.cdi.KrazoCdiExtension;
import org.eclipse.krazo.engine.Viewable;
import org.eclipse.krazo.event.AfterControllerEventImpl;
import org.eclipse.krazo.event.AfterProcessViewEventImpl;
import org.eclipse.krazo.event.BeforeControllerEventImpl;
import org.eclipse.krazo.event.BeforeProcessViewEventImpl;
import org.eclipse.krazo.jaxrs.JaxRsContext;

public class EventDispatcher {
    @Inject
    @JaxRsContext
    private UriInfo uriInfo;
    @Inject
    @JaxRsContext
    private ResourceInfo resourceInfo;
    @Inject
    private Event<MvcEvent> mvcEventDispatcher;

    void fireBeforeControllerEvent() {
        if (KrazoCdiExtension.isEventObserved(BeforeControllerEvent.class)) {
            BeforeControllerEventImpl event = new BeforeControllerEventImpl();
            event.setUriInfo(this.uriInfo);
            event.setResourceInfo(this.resourceInfo);
            this.mvcEventDispatcher.fire((Object)event);
        }
    }

    void fireAfterControllerEvent() {
        if (KrazoCdiExtension.isEventObserved(AfterControllerEvent.class)) {
            AfterControllerEventImpl event = new AfterControllerEventImpl();
            event.setUriInfo(this.uriInfo);
            event.setResourceInfo(this.resourceInfo);
            this.mvcEventDispatcher.fire((Object)event);
        }
    }

    public void fireBeforeProcessViewEvent(ViewEngine engine, Viewable viewable) {
        if (KrazoCdiExtension.isEventObserved(BeforeProcessViewEvent.class)) {
            BeforeProcessViewEventImpl event = new BeforeProcessViewEventImpl();
            event.setEngine(engine.getClass());
            event.setView(viewable.getView());
            this.mvcEventDispatcher.fire((Object)event);
        }
    }

    public void fireAfterProcessViewEvent(ViewEngine engine, Viewable viewable) {
        if (KrazoCdiExtension.isEventObserved(AfterProcessViewEvent.class)) {
            AfterProcessViewEventImpl event = new AfterProcessViewEventImpl();
            event.setEngine(engine.getClass());
            event.setView(viewable.getView());
            this.mvcEventDispatcher.fire((Object)event);
        }
    }
}

