/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class AdminRESTConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    private static final Logger LOG = Logger.getLogger(AdminRESTConfigUpgrade.class.getName());
    @Inject
    Configs configs;
    @Inject
    @Named(value="grizzlyconfigupgrade")
    @Optional
    ConfigurationUpgrade precondition;

    public void postConstruct() {
        for (Config config : this.configs.getConfig()) {
            block8: {
                try {
                    if (config.getAdminListener() == null) {
                        LOG.log(Level.FINE, "Skipping config {0}. No admin listener.", config.getName());
                    }
                    break block8;
                }
                catch (IllegalStateException ise) {
                    LOG.log(Level.FINE, "Skipping config {0}. getAdminListener threw exception", ise);
                }
                continue;
            }
            Protocols ps = config.getNetworkConfig().getProtocols();
            if (ps == null) {
                return;
            }
            for (Protocol p : ps.getProtocol()) {
                Http h = p.getHttp();
                if (h == null || !"__asadmin".equals(h.getDefaultVirtualServer())) continue;
                try {
                    ConfigSupport.apply((SingleConfigCode)new HttpConfigCode(), (ConfigBeanProxy)h);
                }
                catch (TransactionFailure tf) {
                    LOG.log(Level.SEVERE, "Could not upgrade http element for admin console.", tf);
                }
            }
        }
    }

    private static class HttpConfigCode
    implements SingleConfigCode<Http> {
        private HttpConfigCode() {
        }

        public Object run(Http http) throws PropertyVetoException, TransactionFailure {
            http.setEncodedSlashEnabled("true");
            return null;
        }
    }
}

