/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.AliasableNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class NullIfNode
extends Node
implements AliasableNode {
    @Override
    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext generationContext) {
        if (theQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            Expression expression = this.generateExpression(generationContext);
            reportQuery.addItem("NullIf(" + this.getLeft().getAsString() + "," + this.getRight().getAsString() + ")", expression);
        }
    }

    @Override
    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = this.getLeft().generateExpression(context).nullIf(this.getRight().generateExpression(context));
        return whereClause;
    }

    @Override
    public void validate(ParseTreeContext context) {
        this.left.validate(context);
        this.right.validate(context);
        this.setType(this.left.getType());
    }

    @Override
    public boolean isAliasableNode() {
        return true;
    }
}

