/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.lang.reflect.Proxy;
import java.util.Objects;
import org.glassfish.hk2.api.Customize;
import org.glassfish.hk2.api.Customizer;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxyCustomizer;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.WriteableView;

@Customizer(value={ConfigBeanProxyCustomizer.class})
public interface ConfigBeanProxy {
    @Customize
    default public ConfigBeanProxy getParent() {
        Dom parent = Objects.requireNonNull(Dom.unwrap(this)).parent();
        return parent != null ? (ConfigBeanProxy)parent.createProxy() : null;
    }

    @Customize
    default public <T extends ConfigBeanProxy> T getParent(Class<T> type) {
        Dom parent = Objects.requireNonNull(Dom.unwrap(this)).parent();
        return parent != null ? (T)parent.createProxy(type) : null;
    }

    @Customize
    default public <T extends ConfigBeanProxy> T createChild(Class<T> type) throws TransactionFailure {
        try {
            WriteableView bean = (WriteableView)Proxy.getInvocationHandler(this);
            return bean.allocateProxy(type);
        }
        catch (ClassCastException e) {
            throw new TransactionFailure("Must use a locked parent config object for instantiating new config object", e);
        }
    }

    @Customize
    default public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) throws TransactionFailure {
        ConfigBean configBean = (ConfigBean)Dom.unwrap(this);
        Transaction tx = Transaction.getTransaction(parent);
        if (tx == null) {
            throw new TransactionFailure("Must use a locked parent config object for copying new config object");
        }
        ConfigBean copy = Objects.requireNonNull(configBean).copy(configBean.parent());
        return tx.enroll(copy.createProxy());
    }
}

