/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.jwt.eesecurity;

import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import org.omnifaces.jwt.eesecurity.CacheableString;

public class KeyLoadingCache {
    private final Supplier<CacheableString> keySupplier;
    private Duration ttl = Duration.ZERO;
    private long lastUpdated;
    private Optional<String> key;

    public KeyLoadingCache(Supplier<CacheableString> keySupplier) {
        this.keySupplier = keySupplier;
    }

    public Optional<String> get() {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdated > this.ttl.toMillis()) {
            this.refresh();
        }
        return this.key;
    }

    private synchronized void refresh() {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdated > this.ttl.toMillis()) {
            CacheableString result = this.keySupplier.get();
            this.key = result.getValue();
            this.ttl = result.getCacheTTL();
            this.lastUpdated = now;
        }
    }
}

