/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jdeparser.AbstractJClassDef;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.ImplJSourceFile;
import org.jboss.jdeparser.JFiler;
import org.jboss.jdeparser.JPackageInfoFile;
import org.jboss.jdeparser.JSourceFile;
import org.jboss.jdeparser.JSources;
import org.jboss.jdeparser.SourceFileWriter;

class ImplJSources
implements JSources {
    private final JFiler filer;
    private final FormatPreferences format;
    private final List<ImplJSourceFile> classFiles = new ArrayList<ImplJSourceFile>();
    private final Map<String, AbstractJClassDef> classes = new HashMap<String, AbstractJClassDef>();
    private final Map<AbstractJClassDef, String> qualifiedNames = new IdentityHashMap<AbstractJClassDef, String>();

    ImplJSources(JFiler filer, FormatPreferences format) {
        this.filer = filer;
        this.format = format;
    }

    void addClassDef(String qualifiedName, AbstractJClassDef classDef) {
        this.classes.put(qualifiedName, classDef);
        this.qualifiedNames.put(classDef, qualifiedName);
    }

    boolean hasClass(String qualifiedName) {
        return this.classes.containsKey(qualifiedName);
    }

    String qualifiedNameOf(AbstractJClassDef classDef) {
        return this.qualifiedNames.get(classDef);
    }

    @Override
    public JSourceFile createSourceFile(String packageName, String fileName) {
        ImplJSourceFile classFile = new ImplJSourceFile(this, packageName, fileName);
        this.classFiles.add(classFile);
        return classFile;
    }

    @Override
    public JPackageInfoFile createPackageInfoFile(String packageName) {
        throw new UnsupportedOperationException("package-info.java");
    }

    @Override
    public void writeSources() throws IOException {
        for (ImplJSourceFile classFile : this.classFiles) {
            Writer writer = this.filer.openWriter(classFile.getPackageName(), classFile.getFileName());
            Throwable throwable = null;
            try {
                SourceFileWriter sourceFileWriter = new SourceFileWriter(this.format, writer);
                Throwable throwable2 = null;
                try {
                    classFile.write(sourceFileWriter);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (sourceFileWriter == null) continue;
                    if (throwable2 != null) {
                        try {
                            sourceFileWriter.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    sourceFileWriter.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                writer.close();
            }
        }
    }
}

