/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.corba.ee.spi.folb.GroupInfoServiceObserver;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.impl.IIOPImplLogFacade;
import org.glassfish.enterprise.iiop.impl.RoundRobinPolicy;

public class GroupInfoServiceObserverImpl
implements GroupInfoServiceObserver {
    private static final Logger LOG = IIOPImplLogFacade.getLogger(GroupInfoServiceObserverImpl.class);
    private final GroupInfoService gis;
    private final RoundRobinPolicy rr;

    public GroupInfoServiceObserverImpl(GroupInfoService gis, RoundRobinPolicy rr) {
        this.gis = gis;
        this.rr = rr;
    }

    public void forceMembershipChange() {
        this.doMembershipChange();
        LOG.log(Level.FINE, "GroupInfoServiceObserverImpl.forceMembershipChange called");
    }

    public void membershipChange() {
        this.doMembershipChange();
        LOG.log(Level.FINE, "GroupInfoServiceObserverImpl.membershipChange called");
    }

    private void doMembershipChange() {
        try {
            List instanceInfoList = this.gis.getClusterInstanceInfo(null, this.rr.getHostPortList());
            if (instanceInfoList != null && !instanceInfoList.isEmpty()) {
                this.rr.setClusterInstanceInfo(instanceInfoList);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "AS-ORB-00103", e);
        }
    }
}

