/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.DescriptorCompare;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CommitOrderCalculator;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class CommitOrderDependencyNode {
    protected CommitOrderCalculator owner;
    protected ClassDescriptor descriptor;
    protected AbstractSession session;
    protected Vector relatedNodes;
    protected CommitOrderDependencyNode predecessor;
    protected int traversalState;
    public static int NotVisited = 1;
    public static int InProgress = 2;
    public static int Visited = 3;
    protected int discoveryTime;
    protected int finishingTime;

    public CommitOrderDependencyNode(CommitOrderCalculator calculator, ClassDescriptor descriptor, AbstractSession session) {
        this.owner = calculator;
        this.descriptor = descriptor;
        this.relatedNodes = new Vector();
        this.session = session;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public int getFinishingTime() {
        return this.finishingTime;
    }

    public CommitOrderCalculator getOwner() {
        return this.owner;
    }

    public CommitOrderDependencyNode getPredecessor() {
        return this.predecessor;
    }

    public Vector getRelatedNodes() {
        return this.relatedNodes;
    }

    public boolean hasBeenVisited() {
        return this.traversalState == Visited;
    }

    public boolean hasNotBeenVisited() {
        return this.traversalState == NotVisited;
    }

    public void markInProgress() {
        this.traversalState = InProgress;
    }

    public void markNotVisited() {
        this.traversalState = NotVisited;
    }

    public void markVisited() {
        this.traversalState = Visited;
    }

    public void recordMappingDependencies() {
        for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
            Class ownerClass;
            Vector ownedNodes;
            CoreDescriptor refDescriptor;
            if (!mapping.isForeignReferenceMapping()) continue;
            if (mapping.hasConstraintDependency()) {
                Class ownedClass;
                refDescriptor = mapping.getReferenceDescriptor();
                if (refDescriptor == null) {
                    refDescriptor = this.session.getDescriptor((Class)((ForeignReferenceMapping)mapping).getReferenceClass());
                }
                if ((ownedClass = refDescriptor.getJavaClass()) == null) {
                    throw DescriptorException.referenceClassNotSpecified(mapping);
                }
                CommitOrderDependencyNode node = this.getOwner().nodeFor(ownedClass);
                ownedNodes = this.withAllSubclasses(node);
                this.relatedNodes.addAll(ownedNodes);
                continue;
            }
            if (!mapping.hasInverseConstraintDependency()) continue;
            refDescriptor = mapping.getReferenceDescriptor();
            if (refDescriptor == null) {
                refDescriptor = this.session.getDescriptor((Class)((ForeignReferenceMapping)mapping).getReferenceClass());
            }
            if ((ownerClass = refDescriptor.getJavaClass()) == null) {
                throw DescriptorException.referenceClassNotSpecified(mapping);
            }
            CommitOrderDependencyNode ownerNode = this.getOwner().nodeFor(ownerClass);
            ownedNodes = this.withAllSubclasses(this);
            ownerNode.getRelatedNodes().addAll(ownedNodes);
        }
    }

    public void recordSpecifiedDependencies() {
        for (Class<?> ownedClass : this.getDescriptor().getConstraintDependencies()) {
            CommitOrderDependencyNode node = this.getOwner().nodeFor(ownedClass);
            Vector ownedNodes = this.withAllSubclasses(node);
            this.relatedNodes.addAll(ownedNodes);
        }
    }

    public void setDiscoveryTime(int time) {
        this.discoveryTime = time;
    }

    public void setFinishingTime(int time) {
        this.finishingTime = time;
    }

    public void setPredecessor(CommitOrderDependencyNode n) {
        this.predecessor = n;
    }

    public String toString() {
        if (this.descriptor == null) {
            return ToStringLocalization.buildMessage("empty_commit_order_dependency_node", null);
        }
        Object[] args = new Object[]{this.descriptor};
        return ToStringLocalization.buildMessage("node", args);
    }

    public void visit() {
        this.markInProgress();
        int startTime = this.getOwner().getNextTime();
        this.setDiscoveryTime(startTime);
        for (CommitOrderDependencyNode node : this.getRelatedNodes()) {
            if (node.hasNotBeenVisited()) {
                node.setPredecessor(this);
                node.visit();
            }
            if (node.getPredecessor() != null) continue;
            node.setPredecessor(this);
        }
        this.markVisited();
        this.setFinishingTime(this.getOwner().getNextTime());
    }

    public Vector withAllSubclasses(CommitOrderDependencyNode node) {
        Vector<CommitOrderDependencyNode> results = new Vector<CommitOrderDependencyNode>();
        results.add(node);
        if (node.getDescriptor().hasInheritance()) {
            InheritancePolicy policy = node.getDescriptor().getInheritancePolicy();
            ArrayList<ClassDescriptor> childDescriptors = new ArrayList<ClassDescriptor>();
            childDescriptors.addAll(policy.getAllChildDescriptors());
            childDescriptors.sort(new DescriptorCompare());
            for (ClassDescriptor child : childDescriptors) {
                results.add(this.getOwner().nodeFor(child));
            }
        }
        return results;
    }
}

