/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public final class ElementHelper {
    private ElementHelper() {
    }

    public static Optional<TypeMirror> getTypeArgument(Element element) {
        List<? extends TypeMirror> types = ElementHelper.getTypeArguments(element);
        return types.isEmpty() ? Optional.empty() : Optional.of(types.get(0));
    }

    public static List<? extends TypeMirror> getTypeArguments(Element element) {
        return ElementHelper.getTypeArguments(element.asType());
    }

    public static List<? extends TypeMirror> getTypeArguments(TypeMirror type) {
        if (type instanceof DeclaredType) {
            return ((DeclaredType)type).getTypeArguments();
        }
        return Collections.emptyList();
    }

    public static boolean isAnnotatedWith(AnnotatedConstruct annotatedConstruct, Class<? extends Annotation> clazz) {
        if (annotatedConstruct == null) {
            throw new IllegalArgumentException("The element parameter is null");
        }
        Annotation annotation = annotatedConstruct.getAnnotation(clazz);
        return annotation != null;
    }

    public static TypeElement getClassAnnotationValue(Element element, Class<? extends Annotation> annotation) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!annotationType.toString().equals(annotation.getName())) continue;
            AnnotationValue value = annotationMirror.getElementValues().values().iterator().next();
            return (TypeElement)((DeclaredType)value.getValue()).asElement();
        }
        return null;
    }

    public static TypeElement getClassAnnotationValue(Element element, Class<? extends Annotation> annotation, String attributeName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!annotationType.toString().equals(annotation.getName())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            for (ExecutableElement executableElement : map.keySet()) {
                if (!executableElement.getSimpleName().contentEquals(attributeName)) continue;
                return (TypeElement)((DeclaredType)map.get(executableElement).getValue()).asElement();
            }
        }
        return null;
    }

    public static List<TypeMirror> getClassArrayAnnotationValue(Element element, Class<? extends Annotation> annotation, String attributeName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!annotationType.toString().equals(annotation.getName())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            for (ExecutableElement executableElement : map.keySet()) {
                if (!executableElement.getSimpleName().contentEquals(attributeName)) continue;
                List annotationValues = (List)map.get(executableElement).getValue();
                ArrayList<TypeMirror> result = new ArrayList<TypeMirror>(annotationValues.size());
                for (AnnotationValue value : annotationValues) {
                    result.add((TypeMirror)value.getValue());
                }
                return result;
            }
        }
        return Collections.emptyList();
    }

    public static Collection<AnnotationMirror> getAnnotations(Element element, Class<? extends Annotation> groupedAnnotation, Class<? extends Annotation> annotation) {
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>();
        List<? extends AnnotationMirror> annotations = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            if (ElementHelper.isSameType(groupedAnnotation, annotationMirror.getAnnotationType())) {
                result.addAll(ElementHelper.getContainingAnnotations(annotationMirror));
                continue;
            }
            if (!ElementHelper.isSameType(annotation, annotationMirror.getAnnotationType())) continue;
            result.add(annotationMirror);
        }
        return result;
    }

    public static boolean hasConstructor(Types types, Element element, List<TypeMirror> args) {
        int len = args.size();
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
        for (ExecutableElement constructor : constructors) {
            List<? extends VariableElement> parameters = constructor.getParameters();
            if (len != parameters.size()) continue;
            boolean match = false;
            for (int i = 0; i < len; ++i) {
                VariableElement parameter;
                TypeMirror type = args.get(i);
                if (!types.isSameType(type, (parameter = parameters.get(i)).asType())) {
                    match = false;
                    break;
                }
                match = true;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public static TypeElement toTypeElement(ProcessingEnvironment processingEnv, Class<?> type) {
        return ElementHelper.toTypeElement(processingEnv.getElementUtils(), type);
    }

    public static TypeElement toTypeElement(Elements elements, Class<?> type) {
        return elements.getTypeElement(type.getCanonicalName());
    }

    public static TypeMirror toType(ProcessingEnvironment processingEnv, Class<?> type) {
        return ElementHelper.toType(processingEnv.getElementUtils(), type);
    }

    public static TypeMirror toType(Elements elements, Class<?> type) {
        return ElementHelper.toTypeElement(elements, type).asType();
    }

    private static boolean isSameType(Class<?> c, TypeMirror type) {
        return c != null && c.getCanonicalName().equals(type.toString());
    }

    private static Collection<AnnotationMirror> getContainingAnnotations(AnnotationMirror annotation) {
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>();
        Map<? extends ExecutableElement, ? extends AnnotationValue> childAnnotations = annotation.getElementValues();
        childAnnotations.entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().contentEquals("value")).forEach(entry -> {
            Object value = ((AnnotationValue)entry.getValue()).getValue();
            if (value instanceof List) {
                List values = (List)value;
                for (AnnotationValue subValue : values) {
                    if (subValue instanceof AnnotationMirror) {
                        result.add((AnnotationMirror)((Object)subValue));
                        continue;
                    }
                    result.add((AnnotationMirror)subValue.getValue());
                }
            }
        });
        return result;
    }
}

