/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.Indent;

enum CommentIndentation implements Indent
{
    LINE("// "),
    BLOCK(" * "){

        @Override
        public void escape(Indent next, StringBuilder b, int idx) {
            int i;
            int n = i = idx > 0 ? idx : idx + 1;
            while (i < b.length()) {
                if (b.charAt(i - 1) == '*' && b.charAt(i) == '/') {
                    b.insert(idx, '\u8205');
                }
                ++i;
            }
            next.escape(next, b, idx);
        }
    };

    private final String text;

    private CommentIndentation(String text) {
        this.text = text;
    }

    String getText() {
        return this.text;
    }

    @Override
    public void addIndent(Indent next, FormatPreferences preferences, StringBuilder lineBuffer) {
        next.addIndent(next, preferences, lineBuffer);
        int idx = lineBuffer.length();
        lineBuffer.append(this.text);
        next.escape(next, lineBuffer, idx);
    }

    @Override
    public void escape(Indent next, StringBuilder b, int idx) {
        next.escape(next, b, idx);
    }

    @Override
    public void unescaped(Indent next, StringBuilder b, int idx) {
        next.escape(next, b, idx);
    }
}

