/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.policy.spi_impl;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.spi.PolicyFeatureConfigurator;
import com.sun.xml.ws.rx.mc.api.MakeConnectionSupportedFeature;
import com.sun.xml.ws.rx.mc.localization.LocalizationMessages;
import com.sun.xml.ws.rx.mc.policy.wsmc200702.MakeConnectionSupportedAssertion;
import jakarta.xml.ws.WebServiceFeature;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.namespace.QName;

public class McFeatureConfigurator
implements PolicyFeatureConfigurator {
    private static final Logger LOGGER = Logger.getLogger(McFeatureConfigurator.class);

    @Override
    public Collection<WebServiceFeature> getFeatures(PolicyMapKey key, PolicyMap policyMap) throws PolicyException {
        Policy policy;
        LinkedList<WebServiceFeature> features = new LinkedList<WebServiceFeature>();
        if (key != null && policyMap != null && (policy = policyMap.getEndpointEffectivePolicy(key)) != null) {
            for (AssertionSet alternative : policy) {
                MakeConnectionSupportedFeature feature = this.translateIntoMakeConnectionFeature(alternative);
                if (feature == null) continue;
                features.add(feature);
            }
        }
        return features;
    }

    private MakeConnectionSupportedFeature translateIntoMakeConnectionFeature(AssertionSet alternative) throws PolicyException {
        if (this.isPresentAndMandatory(alternative, MakeConnectionSupportedAssertion.NAME)) {
            return new MakeConnectionSupportedFeature();
        }
        return null;
    }

    private Collection<PolicyAssertion> getAssertionsWithName(AssertionSet alternative, QName name) throws PolicyException {
        Collection<PolicyAssertion> assertions = alternative.get(name);
        if (assertions.size() > 1) {
            throw (PolicyException)LOGGER.logSevereException((Throwable)new PolicyException(LocalizationMessages.WSMC_0122_DUPLICATE_ASSERTION_IN_POLICY(assertions.size(), name)));
        }
        return assertions;
    }

    private boolean isPresentAndMandatory(AssertionSet alternative, QName assertionName) throws PolicyException {
        Collection<PolicyAssertion> assertions = this.getAssertionsWithName(alternative, assertionName);
        for (PolicyAssertion assertion : assertions) {
            if (assertion.isOptional()) continue;
            return true;
        }
        return false;
    }
}

