/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.server;

import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.ContainerResolver;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;

public class ThreadLocalContainerResolver
extends ContainerResolver {
    private ThreadLocal<WeakReference<Container>> containerThreadLocal = new ThreadLocal<WeakReference<Container>>(){

        @Override
        protected WeakReference<Container> initialValue() {
            return new WeakReference<Container>(Container.NONE);
        }
    };

    @Override
    public Container getContainer() {
        return (Container)this.containerThreadLocal.get().get();
    }

    public Container enterContainer(Container container) {
        Container old = (Container)this.containerThreadLocal.get().get();
        this.containerThreadLocal.set(new WeakReference<Container>(container));
        return old;
    }

    public void exitContainer(Container old) {
        this.containerThreadLocal.set(new WeakReference<Container>(old));
    }

    public Executor wrapExecutor(final Container container, final Executor ex) {
        if (ex == null) {
            return null;
        }
        return new Executor(){

            @Override
            public void execute(final Runnable command) {
                ex.execute(new Runnable(){

                    @Override
                    public void run() {
                        Container old = ThreadLocalContainerResolver.this.enterContainer(container);
                        try {
                            command.run();
                        }
                        finally {
                            ThreadLocalContainerResolver.this.exitContainer(old);
                        }
                    }
                });
            }
        };
    }
}

