/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.rfc6455.RFC6455Handler;

public enum Version {
    RFC6455("13"){

        @Override
        public ProtocolHandler createHandler(boolean mask) {
            return new RFC6455Handler(mask);
        }

        @Override
        public boolean validate(MimeHeaders headers) {
            return this.wireProtocolVersion.equals(headers.getHeader("Sec-WebSocket-Version"));
        }
    };

    final String wireProtocolVersion;

    public abstract ProtocolHandler createHandler(boolean var1);

    public abstract boolean validate(MimeHeaders var1);

    private Version(String wireProtocolVersion) {
        this.wireProtocolVersion = wireProtocolVersion;
    }

    public String toString() {
        return this.name();
    }

    public static String getSupportedWireProtocolVersions() {
        StringBuilder sb = new StringBuilder();
        for (Version v : Version.values()) {
            if (v.wireProtocolVersion.length() <= 0) continue;
            sb.append(v.wireProtocolVersion).append(", ");
        }
        return sb.substring(0, sb.length() - 2);
    }
}

