/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.glassfish.rmic.BatchEnvironment;
import org.glassfish.rmic.Names;
import org.glassfish.rmic.RMIConstants;
import org.glassfish.rmic.tools.java.ClassDeclaration;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.Identifier;
import org.glassfish.rmic.tools.java.MemberDefinition;
import org.glassfish.rmic.tools.java.Type;

public class RemoteClass
implements RMIConstants {
    private BatchEnvironment env;
    private ClassDefinition implClassDef;
    private ClassDefinition[] remoteInterfaces;
    private Method[] remoteMethods;
    private long interfaceHash;
    private ClassDefinition defRemote;
    private ClassDefinition defException;
    private ClassDefinition defRemoteException;

    public static RemoteClass forClass(BatchEnvironment env, ClassDefinition implClassDef) {
        RemoteClass rc = new RemoteClass(env, implClassDef);
        if (rc.initialize()) {
            return rc;
        }
        return null;
    }

    public ClassDefinition getClassDefinition() {
        return this.implClassDef;
    }

    public Identifier getName() {
        return this.implClassDef.getName();
    }

    public ClassDefinition[] getRemoteInterfaces() {
        return (ClassDefinition[])this.remoteInterfaces.clone();
    }

    public Method[] getRemoteMethods() {
        return (Method[])this.remoteMethods.clone();
    }

    public long getInterfaceHash() {
        return this.interfaceHash;
    }

    public String toString() {
        return "remote class " + this.implClassDef.getName().toString();
    }

    private RemoteClass(BatchEnvironment env, ClassDefinition implClassDef) {
        this.env = env;
        this.implClassDef = implClassDef;
    }

    private boolean initialize() {
        ClassDefinition interfaceDef;
        if (this.implClassDef.isInterface()) {
            this.env.error(0L, "rmic.cant.make.stubs.for.interface", this.implClassDef.getName());
            return false;
        }
        try {
            this.defRemote = this.env.getClassDeclaration(idRemote).getClassDefinition(this.env);
            this.defException = this.env.getClassDeclaration(idJavaLangException).getClassDefinition(this.env);
            this.defRemoteException = this.env.getClassDeclaration(idRemoteException).getClassDefinition(this.env);
        }
        catch (ClassNotFound e) {
            this.env.error(0L, "rmic.class.not.found", e.name);
            return false;
        }
        Vector<ClassDefinition> remotesImplemented = new Vector<ClassDefinition>();
        ClassDefinition classDef = this.implClassDef;
        while (classDef != null) {
            try {
                ClassDeclaration[] interfaces = classDef.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    interfaceDef = interfaces[i].getClassDefinition(this.env);
                    if (remotesImplemented.contains(interfaceDef) || !this.defRemote.implementedBy(this.env, interfaces[i])) continue;
                    remotesImplemented.addElement(interfaceDef);
                    if (!this.env.verbose()) continue;
                    System.out.println("[found remote interface: " + interfaceDef.getName() + "]");
                }
                if (classDef == this.implClassDef && remotesImplemented.isEmpty()) {
                    if (this.defRemote.implementedBy(this.env, this.implClassDef.getClassDeclaration())) {
                        this.env.error(0L, "rmic.must.implement.remote.directly", this.implClassDef.getName());
                    } else {
                        this.env.error(0L, "rmic.must.implement.remote", this.implClassDef.getName());
                    }
                    return false;
                }
                classDef = classDef.getSuperClass() != null ? classDef.getSuperClass().getClassDefinition(this.env) : null;
            }
            catch (ClassNotFound e) {
                this.env.error(0L, "class.not.found", e.name, classDef.getName());
                return false;
            }
        }
        Hashtable<String, Method> methods = new Hashtable<String, Method>();
        boolean errors = false;
        Enumeration enumeration = remotesImplemented.elements();
        while (enumeration.hasMoreElements()) {
            interfaceDef = (ClassDefinition)enumeration.nextElement();
            if (this.collectRemoteMethods(interfaceDef, methods)) continue;
            errors = true;
        }
        if (errors) {
            return false;
        }
        this.remoteInterfaces = new ClassDefinition[remotesImplemented.size()];
        remotesImplemented.copyInto(this.remoteInterfaces);
        String[] orderedKeys = new String[methods.size()];
        int count = 0;
        Enumeration<Method> enumeration2 = methods.elements();
        while (enumeration2.hasMoreElements()) {
            Method m = enumeration2.nextElement();
            String key = m.getNameAndDescriptor();
            for (int i = count; i > 0 && key.compareTo(orderedKeys[i - 1]) < 0; --i) {
                orderedKeys[i] = orderedKeys[i - 1];
            }
            orderedKeys[i] = key;
            ++count;
        }
        this.remoteMethods = new Method[methods.size()];
        for (int i = 0; i < this.remoteMethods.length; ++i) {
            this.remoteMethods[i] = methods.get(orderedKeys[i]);
            if (!this.env.verbose()) continue;
            System.out.print("[found remote method <" + i + ">: " + this.remoteMethods[i].getOperationString());
            ClassDeclaration[] exceptions = this.remoteMethods[i].getExceptions();
            if (exceptions.length > 0) {
                System.out.print(" throws ");
            }
            for (int j = 0; j < exceptions.length; ++j) {
                if (j > 0) {
                    System.out.print(", ");
                }
                System.out.print(exceptions[j].getName());
            }
            System.out.println("]");
        }
        this.interfaceHash = this.computeInterfaceHash();
        return true;
    }

    private boolean collectRemoteMethods(ClassDefinition interfaceDef, Hashtable<String, Method> table) {
        if (!interfaceDef.isInterface()) {
            throw new Error("expected interface, not class: " + interfaceDef.getName());
        }
        boolean errors = false;
        block6: for (MemberDefinition member = interfaceDef.getFirstMember(); member != null; member = member.getNextMember()) {
            Method newMethod;
            String key;
            Method oldMethod;
            block13: {
                if (!member.isMethod() || member.isConstructor() || member.isInitializer()) continue;
                ClassDeclaration[] exceptions = member.getExceptions(this.env);
                boolean hasRemoteException = false;
                for (int i = 0; i < exceptions.length; ++i) {
                    try {
                        if (!this.defRemoteException.subClassOf(this.env, exceptions[i])) continue;
                        hasRemoteException = true;
                        break;
                    }
                    catch (ClassNotFound e) {
                        this.env.error(0L, "class.not.found", e.name, interfaceDef.getName());
                        continue block6;
                    }
                }
                if (!hasRemoteException) {
                    this.env.error(0L, "rmic.must.throw.remoteexception", interfaceDef.getName(), member.toString());
                    errors = true;
                    continue;
                }
                try {
                    MemberDefinition implMethod = this.implClassDef.findMethod(this.env, member.getName(), member.getType());
                    if (implMethod == null) break block13;
                    exceptions = implMethod.getExceptions(this.env);
                    for (int i = 0; i < exceptions.length; ++i) {
                        if (this.defException.superClassOf(this.env, exceptions[i])) continue;
                        this.env.error(0L, "rmic.must.only.throw.exception", implMethod.toString(), exceptions[i].getName());
                        errors = true;
                        continue block6;
                    }
                }
                catch (ClassNotFound e) {
                    this.env.error(0L, "class.not.found", e.name, this.implClassDef.getName());
                    continue;
                }
            }
            if ((oldMethod = table.get(key = (newMethod = new Method(member)).getNameAndDescriptor())) != null && (newMethod = newMethod.mergeWith(oldMethod)) == null) {
                errors = true;
                continue;
            }
            table.put(key, newMethod);
        }
        try {
            ClassDeclaration[] superDefs = interfaceDef.getInterfaces();
            for (int i = 0; i < superDefs.length; ++i) {
                ClassDefinition superDef = superDefs[i].getClassDefinition(this.env);
                if (this.collectRemoteMethods(superDef, table)) continue;
                errors = true;
            }
        }
        catch (ClassNotFound e) {
            this.env.error(0L, "class.not.found", e.name, interfaceDef.getName());
            return false;
        }
        return !errors;
    }

    private long computeInterfaceHash() {
        long hash = 0L;
        ByteArrayOutputStream sink = new ByteArrayOutputStream(512);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            DataOutputStream out = new DataOutputStream(new DigestOutputStream(sink, md));
            out.writeInt(1);
            for (int i = 0; i < this.remoteMethods.length; ++i) {
                MemberDefinition m = this.remoteMethods[i].getMemberDefinition();
                Identifier name = m.getName();
                Type type = m.getType();
                out.writeUTF(name.toString());
                out.writeUTF(type.getTypeSignature());
                ClassDeclaration[] exceptions = m.getExceptions(this.env);
                this.sortClassDeclarations(exceptions);
                for (int j = 0; j < exceptions.length; ++j) {
                    out.writeUTF(Names.mangleClass(exceptions[j].getName()).toString());
                }
            }
            out.flush();
            byte[] hashArray = md.digest();
            for (int i = 0; i < Math.min(8, hashArray.length); ++i) {
                hash += (long)(hashArray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException e) {
            throw new Error("unexpected exception computing intetrface hash: " + e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("unexpected exception computing intetrface hash: " + e);
        }
        return hash;
    }

    private void sortClassDeclarations(ClassDeclaration[] decl) {
        for (int i = 1; i < decl.length; ++i) {
            ClassDeclaration curr = decl[i];
            String name = Names.mangleClass(curr.getName()).toString();
            for (int j = i; j > 0 && name.compareTo(Names.mangleClass(decl[j - 1].getName()).toString()) < 0; --j) {
                decl[j] = decl[j - 1];
            }
            decl[j] = curr;
        }
    }

    public class Method
    implements Cloneable {
        private MemberDefinition memberDef;
        private long methodHash;
        private ClassDeclaration[] exceptions;

        public MemberDefinition getMemberDefinition() {
            return this.memberDef;
        }

        public Identifier getName() {
            return this.memberDef.getName();
        }

        public Type getType() {
            return this.memberDef.getType();
        }

        public ClassDeclaration[] getExceptions() {
            return (ClassDeclaration[])this.exceptions.clone();
        }

        public long getMethodHash() {
            return this.methodHash;
        }

        public String toString() {
            return this.memberDef.toString();
        }

        public String getOperationString() {
            return this.memberDef.toString();
        }

        public String getNameAndDescriptor() {
            return this.memberDef.getName().toString() + this.memberDef.getType().getTypeSignature();
        }

        Method(MemberDefinition memberDef) {
            this.memberDef = memberDef;
            this.exceptions = memberDef.getExceptions(RemoteClass.this.env);
            this.methodHash = this.computeMethodHash();
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error("clone failed");
            }
        }

        private Method mergeWith(Method other) {
            if (!this.getName().equals(other.getName()) || !this.getType().equals(other.getType())) {
                throw new Error("attempt to merge method \"" + other.getNameAndDescriptor() + "\" with \"" + this.getNameAndDescriptor());
            }
            Vector<ClassDeclaration> legalExceptions = new Vector<ClassDeclaration>();
            try {
                this.collectCompatibleExceptions(other.exceptions, this.exceptions, legalExceptions);
                this.collectCompatibleExceptions(this.exceptions, other.exceptions, legalExceptions);
            }
            catch (ClassNotFound e) {
                RemoteClass.this.env.error(0L, "class.not.found", e.name, RemoteClass.this.getClassDefinition().getName());
                return null;
            }
            Method merged = (Method)this.clone();
            merged.exceptions = new ClassDeclaration[legalExceptions.size()];
            legalExceptions.copyInto(merged.exceptions);
            return merged;
        }

        private void collectCompatibleExceptions(ClassDeclaration[] from, ClassDeclaration[] with, Vector<ClassDeclaration> list) throws ClassNotFound {
            block0: for (int i = 0; i < from.length; ++i) {
                ClassDefinition exceptionDef = from[i].getClassDefinition(RemoteClass.this.env);
                if (list.contains(from[i])) continue;
                for (int j = 0; j < with.length; ++j) {
                    if (!exceptionDef.subClassOf(RemoteClass.this.env, with[j])) continue;
                    list.addElement(from[i]);
                    continue block0;
                }
            }
        }

        private long computeMethodHash() {
            long hash = 0L;
            ByteArrayOutputStream sink = new ByteArrayOutputStream(512);
            try {
                MessageDigest md = MessageDigest.getInstance("SHA");
                DataOutputStream out = new DataOutputStream(new DigestOutputStream(sink, md));
                String methodString = this.getNameAndDescriptor();
                if (RemoteClass.this.env.verbose()) {
                    System.out.println("[string used for method hash: \"" + methodString + "\"]");
                }
                out.writeUTF(methodString);
                out.flush();
                byte[] hashArray = md.digest();
                for (int i = 0; i < Math.min(8, hashArray.length); ++i) {
                    hash += (long)(hashArray[i] & 0xFF) << i * 8;
                }
            }
            catch (IOException e) {
                throw new Error("unexpected exception computing intetrface hash: " + e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error("unexpected exception computing intetrface hash: " + e);
            }
            return hash;
        }
    }
}

