/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.function.Consumer;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;
import org.eclipse.persistence.tools.schemaframework.TableValidationException;

public class TableCreator {
    public static final String DEFAULT_IDENTITY_GENERATOR = "SEQ_GEN_IDENTITY";
    public static boolean CHECK_EXISTENCE = true;
    protected List<TableDefinition> tableDefinitions;
    protected String name;
    protected boolean ignoreDatabaseException;

    public TableCreator() {
        this(new ArrayList<TableDefinition>());
    }

    public TableCreator(List<TableDefinition> tableDefinitions) {
        this.tableDefinitions = tableDefinitions;
    }

    public void addTableDefinition(TableDefinition tableDefinition) {
        this.tableDefinitions.add(tableDefinition);
    }

    public void addTableDefinitions(Collection<TableDefinition> tableDefs) {
        this.tableDefinitions.addAll(tableDefs);
    }

    public void createConstraints(DatabaseSession session) {
        this.createConstraints(session, new SchemaManager(session));
    }

    public void createConstraints(DatabaseSession session, SchemaManager schemaManager) {
        this.createConstraints(session, schemaManager, true);
    }

    public void createConstraints(DatabaseSession session, SchemaManager schemaManager, boolean build) {
        this.createConstraints(this.getTableDefinitions(), session, schemaManager, build);
    }

    public void createConstraints(List<TableDefinition> tables, DatabaseSession session, SchemaManager schemaManager, boolean build) {
        this.buildConstraints(schemaManager, build);
        for (TableDefinition table : tables) {
            try {
                schemaManager.createUniqueConstraints(table);
            }
            catch (DatabaseException ex) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
        for (TableDefinition table : tables) {
            try {
                schemaManager.createForeignConstraints(table);
            }
            catch (DatabaseException ex) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
    }

    public void createTables(DatabaseSession session) {
        this.createTables(session, new SchemaManager(session));
    }

    public void createTables(DatabaseSession session, SchemaManager schemaManager) {
        this.createTables(session, schemaManager, true);
    }

    public void createTables(DatabaseSession session, SchemaManager schemaManager, boolean build) {
        this.createTables(session, schemaManager, build, true, true, true);
    }

    public void createTables(DatabaseSession session, SchemaManager schemaManager, boolean build, boolean check, boolean createSequenceTables, boolean createSequences) {
        this.buildConstraints(schemaManager, build);
        String sequenceTableName = this.getSequenceTableName(session);
        ArrayList<TableDefinition> missingTables = new ArrayList<TableDefinition>();
        for (TableDefinition table : this.getTableDefinitions()) {
            if (table.getName().equals(sequenceTableName)) continue;
            boolean alreadyExists = false;
            if (check && CHECK_EXISTENCE && schemaManager.shouldWriteToDatabase()) {
                alreadyExists = schemaManager.checkTableExists(table);
            }
            if (alreadyExists) continue;
            missingTables.add(table);
            try {
                schemaManager.createObject(table);
                session.getSessionLog().log(1, "ddl", "default_tables_created", (Object)table.getFullName());
            }
            catch (DatabaseException ex) {
                session.getSessionLog().log(1, "ddl", "default_tables_already_existed", (Object)table.getFullName());
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
        this.createConstraints(missingTables, session, schemaManager, false);
        schemaManager.createOrReplaceSequences(createSequenceTables, createSequences);
        session.getDatasourcePlatform().initIdentitySequences(session, DEFAULT_IDENTITY_GENERATOR);
    }

    public void dropConstraints(DatabaseSession session) {
        this.dropConstraints(session, new SchemaManager(session));
    }

    public void dropConstraints(DatabaseSession session, SchemaManager schemaManager) {
        this.dropConstraints(session, schemaManager, true);
    }

    public void dropConstraints(DatabaseSession session, SchemaManager schemaManager, boolean build) {
        this.buildConstraints(schemaManager, build);
        for (TableDefinition table : this.getTableDefinitions()) {
            try {
                schemaManager.dropConstraints(table);
            }
            catch (DatabaseException databaseException) {}
        }
    }

    public void dropTables(DatabaseSession session) {
        this.dropTables(session, new SchemaManager(session));
    }

    public void dropTables(DatabaseSession session, SchemaManager schemaManager) {
        this.dropTables(session, schemaManager, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTables(DatabaseSession session, SchemaManager schemaManager, boolean build) {
        this.buildConstraints(schemaManager, build);
        boolean shouldLogExceptionStackTrace = session.getSessionLog().shouldLogExceptionStackTrace();
        int level = session.getSessionLog().getLevel();
        if (shouldLogExceptionStackTrace) {
            session.getSessionLog().setShouldLogExceptionStackTrace(false);
        }
        if (level > 3) {
            session.getSessionLog().setLevel(7);
        }
        try {
            this.dropConstraints(session, schemaManager, false);
            String sequenceTableName = this.getSequenceTableName(session);
            List<TableDefinition> tables = this.getTableDefinitions();
            int trys = 1;
            if (SchemaManager.FORCE_DROP) {
                trys = 5;
            }
            while (trys > 0 && !tables.isEmpty()) {
                --trys;
                ArrayList<TableDefinition> failed = new ArrayList<TableDefinition>();
                HashSet<String> tableNames = new HashSet<String>(tables.size());
                for (TableDefinition table : tables) {
                    String tableName = table.getName();
                    if (tableName.equals(sequenceTableName)) continue;
                    try {
                        schemaManager.dropObject(table);
                        tableNames.add(tableName);
                    }
                    catch (DatabaseException exception) {
                        failed.add(table);
                        if (this.shouldIgnoreDatabaseException()) continue;
                        throw exception;
                    }
                }
                session.getDatasourcePlatform().removeIdentitySequences(session, DEFAULT_IDENTITY_GENERATOR, tableNames);
                tables = failed;
            }
        }
        finally {
            if (shouldLogExceptionStackTrace) {
                session.getSessionLog().setShouldLogExceptionStackTrace(true);
            }
            if (level > 3) {
                session.getSessionLog().setLevel(level);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public List<TableDefinition> getTableDefinitions() {
        return this.tableDefinitions;
    }

    public void replaceTables(DatabaseSession session) {
        this.replaceTables(session, new SchemaManager(session));
    }

    public void replaceTables(DatabaseSession session, SchemaManager schemaManager) {
        this.replaceTables(session, schemaManager, true, true);
    }

    public void replaceTables(DatabaseSession session, SchemaManager schemaManager, boolean createSequenceTables) {
        this.replaceTables(session, schemaManager, createSequenceTables, false);
    }

    public void replaceTables(DatabaseSession session, SchemaManager schemaManager, boolean createSequenceTables, boolean createSequences) {
        this.replaceTablesAndConstraints(schemaManager, session, createSequenceTables, createSequences);
    }

    void truncateTables(DatabaseSession session, SchemaManager schemaManager, boolean generateFKConstraints) {
        TableCreator tableCreator = schemaManager.getDefaultTableCreator(generateFKConstraints);
        String sequenceTableName = tableCreator.getSequenceTableName(session);
        List<TableDefinition> tables = tableCreator.getTableDefinitions();
        this.dropConstraints(session, schemaManager, false);
        for (TableDefinition table : tables) {
            if (table.getName().equals(sequenceTableName)) continue;
            try {
                StringWriter stmtWriter = new StringWriter();
                session.getPlatform().writeTruncateTable(stmtWriter, (AbstractSession)((Object)session), table);
                ((AbstractSession)((Object)session)).priviledgedExecuteNonSelectingCall(new SQLCall(((Object)stmtWriter).toString()));
            }
            catch (DatabaseException ex) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
            catch (IOException ex) {
                throw ValidationException.tablesTruncationFailed(ex);
            }
        }
        this.createConstraints(tables, session, schemaManager, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceTablesAndConstraints(SchemaManager schemaManager, DatabaseSession session, boolean createSequenceTables, boolean createSequences) {
        this.buildConstraints(schemaManager, true);
        boolean ignore = this.shouldIgnoreDatabaseException();
        this.setIgnoreDatabaseException(true);
        try {
            this.dropTables(session, schemaManager, false);
        }
        finally {
            this.setIgnoreDatabaseException(ignore);
        }
        this.createTables(session, schemaManager, false, false, createSequenceTables, createSequences);
    }

    protected void replaceTablesAndConstraints(SchemaManager schemaManager, DatabaseSession session) {
        this.replaceTables(session, schemaManager, false, false);
    }

    protected void buildConstraints(SchemaManager schemaManager, boolean build) {
        if (build) {
            for (TableDefinition table : this.getTableDefinitions()) {
                schemaManager.buildFieldTypes(table);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTableDefinitions(List<TableDefinition> tableDefinitions) {
        this.tableDefinitions = tableDefinitions;
    }

    public boolean shouldIgnoreDatabaseException() {
        return this.ignoreDatabaseException;
    }

    public void setIgnoreDatabaseException(boolean ignoreDatabaseException) {
        this.ignoreDatabaseException = ignoreDatabaseException;
    }

    protected String getSequenceTableName(Session session) {
        Sequence sequence;
        String sequenceTableName = null;
        if (session.getProject().usesSequencing() && (sequence = session.getLogin().getDefaultSequence()) instanceof TableSequence) {
            sequenceTableName = ((TableSequence)sequence).getQualifiedTableName();
        }
        return sequenceTableName;
    }

    public void extendTables(DatabaseSession session, SchemaManager schemaManager) {
        this.extendTablesAndConstraints(schemaManager, session);
        schemaManager.createOrReplaceSequences(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extendTablesAndConstraints(SchemaManager schemaManager, DatabaseSession session) {
        this.buildConstraints(schemaManager, true);
        boolean ignore = this.shouldIgnoreDatabaseException();
        this.setIgnoreDatabaseException(true);
        try {
            this.extendTables(session, schemaManager, false);
        }
        finally {
            this.setIgnoreDatabaseException(ignore);
        }
    }

    public boolean validateTables(DatabaseSession session, SchemaManager schemaManager, Consumer<List<TableValidationException>> onFailed, boolean full) {
        List<TableDefinition> tableDefinitions = this.getTableDefinitions();
        ArrayList exceptions = new ArrayList(tableDefinitions.size());
        tableDefinitions.forEach(tableDefinition -> {
            String tableName;
            String string = tableName = tableDefinition.getTable() == null ? tableDefinition.getName() : tableDefinition.getTable().getName();
            if (schemaManager.checkTableExists((TableDefinition)tableDefinition)) {
                List<AbstractRecord> columnsInfo = this.readColumnInfo((AbstractSession)((Object)session), (TableDefinition)tableDefinition);
                if (columnsInfo != null && !columnsInfo.isEmpty()) {
                    Map<DatabaseField, AbstractRecord> columns = TableCreator.parseColumnInfo((AbstractSession)((Object)session), tableDefinition, columnsInfo);
                    CheckDatabaseColumns check = new CheckDatabaseColumns(session, columns.size(), full);
                    TableCreator.processColumns(tableDefinition, columns, check::checkExisting, check::addMissing, check::surplusColumns);
                    if (!check.getMissingColumns().isEmpty()) {
                        exceptions.add(new TableValidationException.MissingColumns(tableName, List.copyOf(check.getMissingColumns())));
                    }
                    if (!check.getSurplusFields().isEmpty()) {
                        exceptions.add(new TableValidationException.SurplusColumns(tableName, List.copyOf(check.getSurplusFields().stream().map(DatabaseField::getName).toList())));
                    }
                    if (!check.getExistingColumnsDiff().isEmpty()) {
                        exceptions.add(new TableValidationException.DifferentColumns(tableName, List.copyOf(check.getExistingColumnsDiff())));
                    }
                }
            } else {
                exceptions.add(new TableValidationException.MissingTable(tableName));
            }
        });
        if (exceptions.isEmpty()) {
            return true;
        }
        if (onFailed != null) {
            onFailed.accept(exceptions);
        }
        return false;
    }

    public void extendTables(DatabaseSession session, SchemaManager schemaManager, boolean build) {
        this.buildConstraints(schemaManager, build);
        String sequenceTableName = this.getSequenceTableName(session);
        for (TableDefinition table : this.getTableDefinitions()) {
            if (table.getName().equals(sequenceTableName)) continue;
            AbstractSession abstractSession = (AbstractSession)((Object)session);
            boolean alreadyExists = false;
            if (CHECK_EXISTENCE && schemaManager.shouldWriteToDatabase()) {
                alreadyExists = schemaManager.checkTableExists(table);
            }
            DatabaseException createTableException = null;
            if (!alreadyExists) {
                try {
                    schemaManager.createObject(table);
                    session.getSessionLog().log(1, "ddl", "default_tables_created", (Object)table.getFullName());
                }
                catch (DatabaseException exception) {
                    createTableException = exception;
                    alreadyExists = true;
                }
            }
            if (!alreadyExists) continue;
            String tableName = table.getTable() == null ? table.getName() : table.getTable().getName();
            boolean usesDelimiting = table.getTable() != null && table.getTable().shouldUseDelimiters();
            Vector<AbstractRecord> columnInfo = null;
            columnInfo = abstractSession.getAccessor().getColumnInfo(tableName, null, abstractSession);
            if (!usesDelimiting && (columnInfo == null || columnInfo.isEmpty())) {
                tableName = tableName.toUpperCase();
                columnInfo = abstractSession.getAccessor().getColumnInfo(tableName, null, abstractSession);
                if (columnInfo == null || columnInfo.isEmpty()) {
                    tableName = tableName.toLowerCase();
                    columnInfo = abstractSession.getAccessor().getColumnInfo(tableName, null, abstractSession);
                }
            }
            if (columnInfo != null && !columnInfo.isEmpty()) {
                DatabasePlatform platform;
                HashMap<DatabaseField, AbstractRecord> columns = new HashMap<DatabaseField, AbstractRecord>(columnInfo.size());
                DatabaseField columnNameLookupField = new DatabaseField("COLUMN_NAME");
                DatabaseField schemaLookupField = new DatabaseField("TABLE_SCHEM");
                boolean schemaMatchFound = false;
                String qualifier = table.getQualifier();
                if (!(qualifier != null && qualifier.length() != 0 || (qualifier = session.getDatasourcePlatform().getTableQualifier()) != null && qualifier.length() != 0 || (qualifier = session.getLogin().getUserName()) != null && qualifier.length() != 0 || !(platform = session.getPlatform()).supportsConnectionUserName())) {
                    qualifier = platform.getConnectionUserName();
                }
                boolean checkSchema = qualifier != null && qualifier.length() > 0;
                for (AbstractRecord record : columnInfo) {
                    String fieldName = (String)record.get(columnNameLookupField);
                    if (fieldName == null || fieldName.length() <= 0) continue;
                    DatabaseField column = new DatabaseField(fieldName);
                    if (session.getPlatform().shouldForceFieldNamesToUpperCase()) {
                        column.useUpperCaseForComparisons(true);
                    }
                    String schema = (String)record.get(schemaLookupField);
                    if (schemaMatchFound) {
                        if (!qualifier.equalsIgnoreCase(schema)) continue;
                        columns.put(column, record);
                        continue;
                    }
                    if (checkSchema && qualifier.equalsIgnoreCase(schema)) {
                        schemaMatchFound = true;
                        columns.clear();
                    }
                    columns.put(column, record);
                }
                for (FieldDefinition fieldDef : table.getFields()) {
                    DatabaseField dbField = fieldDef.getDatabaseField();
                    if (dbField == null) {
                        dbField = new DatabaseField(fieldDef.getName());
                    }
                    if (columns.get(dbField) != null) continue;
                    try {
                        table.addFieldOnDatabase(abstractSession, fieldDef);
                    }
                    catch (DatabaseException addFieldEx) {
                        session.getSessionLog().log(1, "ddl", "cannot_add_field_to_table", (Object)dbField.getName(), (Object)table.getFullName(), (Object)addFieldEx.getMessage());
                        if (this.shouldIgnoreDatabaseException()) continue;
                        throw addFieldEx;
                    }
                }
                continue;
            }
            if (createTableException == null) continue;
            session.getSessionLog().log(1, "ddl", "cannot_create_table", (Object)table.getFullName(), (Object)createTableException.getMessage());
            if (this.shouldIgnoreDatabaseException()) continue;
            throw createTableException;
        }
        this.createConstraints(session, schemaManager, false);
        schemaManager.createSequences();
        session.getDatasourcePlatform().initIdentitySequences(session, DEFAULT_IDENTITY_GENERATOR);
    }

    private List<AbstractRecord> readColumnInfo(AbstractSession session, TableDefinition table) {
        String tableName = table.getTable() == null ? table.getName() : table.getTable().getName();
        boolean notUsesDelimiting = table.getTable() == null || !table.getTable().shouldUseDelimiters();
        Vector<AbstractRecord> columnInfo = session.getAccessor().getColumnInfo(tableName, null, session);
        if (notUsesDelimiting && (columnInfo == null || columnInfo.isEmpty())) {
            tableName = tableName.toUpperCase();
            columnInfo = session.getAccessor().getColumnInfo(tableName, null, session);
            if (columnInfo == null || columnInfo.isEmpty()) {
                tableName = tableName.toLowerCase();
                columnInfo = session.getAccessor().getColumnInfo(tableName, null, session);
            }
        }
        return columnInfo;
    }

    private static Map<DatabaseField, AbstractRecord> parseColumnInfo(AbstractSession session, TableDefinition table, List<AbstractRecord> columnInfo) {
        DatabasePlatform platform;
        HashMap<DatabaseField, AbstractRecord> columns = new HashMap<DatabaseField, AbstractRecord>(columnInfo.size());
        DatabaseField columnNameLookupField = new DatabaseField("COLUMN_NAME");
        DatabaseField schemaLookupField = new DatabaseField("TABLE_SCHEM");
        boolean schemaMatchFound = false;
        String qualifier = table.getQualifier();
        if ((qualifier == null || qualifier.isEmpty()) && ((qualifier = session.getDatasourcePlatform().getTableQualifier()) == null || qualifier.isEmpty()) && ((qualifier = session.getLogin().getUserName()) == null || qualifier.isEmpty()) && (platform = session.getPlatform()).supportsConnectionUserName()) {
            qualifier = platform.getConnectionUserName();
        }
        boolean checkSchema = qualifier != null && !qualifier.isEmpty();
        for (AbstractRecord record : columnInfo) {
            String fieldName = (String)record.get(columnNameLookupField);
            if (fieldName == null || fieldName.isEmpty()) continue;
            DatabaseField column = new DatabaseField(fieldName);
            if (session.getPlatform().shouldForceFieldNamesToUpperCase()) {
                column.useUpperCaseForComparisons(true);
            }
            String schema = (String)record.get(schemaLookupField);
            if (schemaMatchFound) {
                if (!qualifier.equalsIgnoreCase(schema)) continue;
                columns.put(column, record);
                continue;
            }
            if (checkSchema && qualifier.equalsIgnoreCase(schema)) {
                schemaMatchFound = true;
                columns.clear();
            }
            columns.put(column, record);
        }
        return columns;
    }

    private static void processMissingColumns(TableDefinition table, Map<DatabaseField, AbstractRecord> columns, CheckDatabaseColumns.MissingField missingAction) {
        TableCreator.processColumns(table, columns, null, missingAction, null);
    }

    private static void processColumns(TableDefinition table, Map<DatabaseField, AbstractRecord> columns, CheckDatabaseColumns.ExistingField existingAction, CheckDatabaseColumns.MissingField missingAction, CheckDatabaseColumns.SurplusFields surplusAction) {
        boolean isSurplusAction = surplusAction != null;
        HashSet<DatabaseField> surplusSet = isSurplusAction ? new HashSet<DatabaseField>(columns.keySet()) : null;
        for (FieldDefinition fieldDef : table.getFields()) {
            AbstractRecord dbColumn;
            DatabaseField dbField = fieldDef.getDatabaseField();
            if (dbField == null) {
                dbField = new DatabaseField(fieldDef.getName());
            }
            if ((dbColumn = columns.get(dbField)) == null && missingAction != null) {
                missingAction.accept(fieldDef, dbField);
                continue;
            }
            if (existingAction != null) {
                existingAction.accept(fieldDef, dbField, dbColumn);
            }
            if (!isSurplusAction) continue;
            surplusSet.remove(dbField);
        }
        if (isSurplusAction) {
            surplusAction.accept(surplusSet);
        }
    }

    private static final class CheckDatabaseColumns {
        final DatabaseSession session;
        final boolean full;
        final List<String> missingColumns;
        final List<TableValidationException.DifferentColumns.Difference> existingColumnsDiff;
        Set<DatabaseField> surplusFields;

        private CheckDatabaseColumns(DatabaseSession session, int size, boolean full) {
            this.session = session;
            this.full = full;
            this.missingColumns = new ArrayList<String>(size);
            this.existingColumnsDiff = new LinkedList<TableValidationException.DifferentColumns.Difference>();
            this.surplusFields = null;
        }

        private void addMissing(FieldDefinition fieldDefinition, DatabaseField databaseField) {
            this.missingColumns.add(databaseField.getName());
        }

        private void checkExisting(FieldDefinition fieldDefinition, DatabaseField databaseField, AbstractRecord dbRecord) {
            if (this.full) {
                FieldTypeDefinition expectedDbType = DatabaseObjectDefinition.getFieldTypeDefinition(this.session.getPlatform(), fieldDefinition.getType(), fieldDefinition.getTypeName());
                String dbTypeName = (String)dbRecord.get("TYPE_NAME");
                if (dbTypeName != null) {
                    Nullable dbNullable;
                    if (!expectedDbType.isTypeName(dbTypeName, false)) {
                        this.existingColumnsDiff.add(new TableValidationException.DifferentColumns.TypeDifference(databaseField.getName(), expectedDbType.getName(), dbTypeName));
                    }
                    if ((dbNullable = this.dbColumnNullable(dbRecord)) != Nullable.UNKNOWN) {
                        boolean modelIsNullable = fieldDefinition.shouldPrintFieldNullClause(expectedDbType);
                        switch (dbNullable.ordinal()) {
                            case 2: {
                                if (!modelIsNullable) break;
                                this.existingColumnsDiff.add(new TableValidationException.DifferentColumns.NullableDifference(databaseField.getName(), true, false));
                                break;
                            }
                            case 1: {
                                if (modelIsNullable) break;
                                this.existingColumnsDiff.add(new TableValidationException.DifferentColumns.NullableDifference(databaseField.getName(), false, true));
                            }
                        }
                    }
                }
            }
        }

        private void surplusColumns(Set<DatabaseField> databaseFields) {
            this.surplusFields = databaseFields;
        }

        private Set<DatabaseField> getSurplusFields() {
            return this.surplusFields;
        }

        private List<String> getMissingColumns() {
            return this.missingColumns;
        }

        private List<TableValidationException.DifferentColumns.Difference> getExistingColumnsDiff() {
            return this.existingColumnsDiff;
        }

        private Nullable dbColumnNullable(AbstractRecord dbRecord) {
            Nullable result = Nullable.parseIsNullable((String)dbRecord.get("IS_NULLABLE"));
            if (result == Nullable.UNKNOWN) {
                result = Nullable.parseNullable((Integer)dbRecord.get("NULLABLE"));
            }
            return result;
        }

        private static enum Nullable {
            UNKNOWN,
            YES,
            NO;


            private static Nullable parseIsNullable(String isNullable) {
                if (isNullable == null) {
                    return UNKNOWN;
                }
                return switch (isNullable.toUpperCase()) {
                    case "NO" -> NO;
                    case "YES" -> YES;
                    default -> UNKNOWN;
                };
            }

            private static Nullable parseNullable(Integer nullable) {
                if (nullable == null) {
                    return UNKNOWN;
                }
                return switch (nullable) {
                    case 0 -> NO;
                    case 1 -> YES;
                    default -> UNKNOWN;
                };
            }
        }

        @FunctionalInterface
        private static interface SurplusFields {
            public void accept(Set<DatabaseField> var1);
        }

        @FunctionalInterface
        private static interface MissingField {
            public void accept(FieldDefinition var1, DatabaseField var2);
        }

        @FunctionalInterface
        private static interface ExistingField {
            public void accept(FieldDefinition var1, DatabaseField var2, AbstractRecord var3);
        }
    }
}

