/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.MetadataLogger;
import org.jboss.weld.logging.WeldLogger;

public class MetadataLogger_$logger
extends DelegatingBasicLogger
implements MetadataLogger,
WeldLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MetadataLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public MetadataLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String metaAnnotationOnWrongType$str() {
        return "WELD-001100: {0} can only be applied to an annotation.  It was applied to {1}";
    }

    @Override
    public final DefinitionException metaAnnotationOnWrongType(Object param1, Object param2) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.metaAnnotationOnWrongType$str(), param1, param2));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    @Override
    public final void nonBindingMemberType(Object param1) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.nonBindingMemberType$str(), param1);
    }

    protected String nonBindingMemberType$str() {
        return "WELD-001101: Member of array type or annotation type must be annotated @NonBinding:  {0}";
    }

    protected String stereotypeNotRegistered$str() {
        return "WELD-001102: Stereotype {0} not registered with container";
    }

    @Override
    public final IllegalStateException stereotypeNotRegistered(Object param1) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.stereotypeNotRegistered$str(), param1));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String qualifierOnStereotype$str() {
        return "WELD-001103: Cannot declare qualifiers on stereotype {0}";
    }

    @Override
    public final DefinitionException qualifierOnStereotype(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.qualifierOnStereotype$str(), param1));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String valueOnNamedStereotype$str() {
        return "WELD-001104: Cannot specify a value for @Named stereotype {0}";
    }

    @Override
    public final DefinitionException valueOnNamedStereotype(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.valueOnNamedStereotype$str(), param1));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleScopes$str() {
        return "WELD-001105: At most one scope type may be specified for {0}";
    }

    @Override
    public final DefinitionException multipleScopes(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.multipleScopes$str(), param1));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String stereotypesNull$str() {
        return "WELD-001106: BeanAttributes.getStereotypes() returned null for {0}";
    }

    @Override
    public final DefinitionException stereotypesNull(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.stereotypesNull$str(), param1));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String qualifiersNull$str() {
        return "WELD-001107: {0}() returned null for {1}";
    }

    @Override
    public final DefinitionException qualifiersNull(Object param1, Object param2) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.qualifiersNull$str(), param1, param2));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String typesNull$str() {
        return "WELD-001108: BeanAttributes.getTypes() returned null for {0}";
    }

    @Override
    public final DefinitionException typesNull(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.typesNull$str(), param1));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String scopeNull$str() {
        return "WELD-001109: BeanAttributes.getScope() returned null for {0}";
    }

    @Override
    public final DefinitionException scopeNull(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.scopeNull$str(), param1));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAStereotype$str() {
        return "WELD-001110: {0} defined on {1} is not a stereotype";
    }

    @Override
    public final DefinitionException notAStereotype(Object param1, Object param2) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.notAStereotype$str(), param1, param2));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAQualifier$str() {
        return "WELD-001111: {0} defined on {1} is not a qualifier";
    }

    @Override
    public final DefinitionException notAQualifier(Object param1, Object param2) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.notAQualifier$str(), param1, param2));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String typesEmpty$str() {
        return "WELD-001112: BeanAttributes.getTypes() may not return an empty set {0}";
    }

    @Override
    public final DefinitionException typesEmpty(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.typesEmpty$str(), param1));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAScope$str() {
        return "WELD-001113: {0} defined on {1} is not a scope annotation";
    }

    @Override
    public final DefinitionException notAScope(Object param1, Object param2) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.notAScope$str(), param1, param2));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String metadataSourceReturnedNull$str() {
        return "WELD-001114: {0} returned null for {1}";
    }

    @Override
    public final IllegalArgumentException metadataSourceReturnedNull(Object param1, Object param2) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.metadataSourceReturnedNull$str(), param1, param2));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidParameterPosition$str() {
        return "WELD-001115: Parameter position {0} of parameter {1} is not valid";
    }

    @Override
    public final IllegalArgumentException invalidParameterPosition(Object param1, Object param2) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidParameterPosition$str(), param1, param2));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void noConstructor(Object param1) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.noConstructor$str(), param1);
    }

    protected String noConstructor$str() {
        return "WELD-001116: AnnotatedType ({0}) without a constructor";
    }

    @Override
    public final void notInHierarchy(Object memberName, Object member, Object annotatedTypeJavaClassName, Object annotatedType, Object stackElement) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.notInHierarchy$str(), memberName, member, annotatedTypeJavaClassName, annotatedType, stackElement);
    }

    protected String notInHierarchy$str() {
        return "WELD-001117: Member {0} ({1}) does not belong to the actual class hierarchy of the annotatedType {2} ({3})\n\tat {4}";
    }

    protected String typeVariableIsNotAValidBeanType$str() {
        return "WELD-001118: A type variable is not a valid bean type. Bean type {0} of bean {1}";
    }

    @Override
    public final DefinitionException typeVariableIsNotAValidBeanType(Object param1, Object param2) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.typeVariableIsNotAValidBeanType$str(), param1, param2));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String parameterizedTypeContainingWildcardParameterIsNotAValidBeanType$str() {
        return "WELD-001119: A parameterized type containing wildcard parameters is not a valid bean type. Bean type {0} of bean {1}";
    }

    @Override
    public final DefinitionException parameterizedTypeContainingWildcardParameterIsNotAValidBeanType(Object param1, Object param2) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.parameterizedTypeContainingWildcardParameterIsNotAValidBeanType$str(), param1, param2));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String beanWithParameterizedTypeContainingTypeVariablesMustBeDependentScoped$str() {
        return "WELD-001120: A bean that has a parameterized bean type containing type variables must be @Dependent scoped. Bean type {0} of bean {1}";
    }

    @Override
    public final DefinitionException beanWithParameterizedTypeContainingTypeVariablesMustBeDependentScoped(Object param1, Object param2) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.beanWithParameterizedTypeContainingTypeVariablesMustBeDependentScoped$str(), param1, param2));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonBindingMemberTypeException$str() {
        return "WELD-001121: Member of array type or annotation type must be annotated @NonBinding:  {0}";
    }

    @Override
    public final DefinitionException nonBindingMemberTypeException(Object param1) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.nonBindingMemberTypeException$str(), param1));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String annotatedTypeDeserializationFailure$str() {
        return "WELD-001122: Failed to deserialize annotated type identified with {0}";
    }

    @Override
    public final IllegalStateException annotatedTypeDeserializationFailure(AnnotatedTypeIdentifier identifier) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.annotatedTypeDeserializationFailure$str(), identifier));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAnInterceptorBinding$str() {
        return "WELD-001123: {0} defined on {1} is not an interceptor binding";
    }

    @Override
    public final DefinitionException notAnInterceptorBinding(Object param1, Object param2) {
        DefinitionException result = new DefinitionException(this._formatMessage(this.notAnInterceptorBinding$str(), param1, param2));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void contextGetScopeIsNotAScope(Object param1, Object param2) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.contextGetScopeIsNotAScope$str(), param1, param2);
    }

    protected String contextGetScopeIsNotAScope$str() {
        return "WELD-001124: Context.getScope() returned {0} which is not a scope annotation. Context: {1}";
    }

    @Override
    public final void illegalBeanTypeIgnored(Object type, Object annotated) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.illegalBeanTypeIgnored$str(), type, annotated);
    }

    protected String illegalBeanTypeIgnored$str() {
        return "WELD-001125: Illegal bean type {0} ignored on {1}";
    }

    protected String beanAttributesConfiguratorCannotReadAnnotatedType$str() {
        return "WELD-001126: BeanAttributesConfigurator is not able to read {0} - missing BeanManager";
    }

    @Override
    public final IllegalStateException beanAttributesConfiguratorCannotReadAnnotatedType(Object type) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.beanAttributesConfiguratorCannotReadAnnotatedType$str(), type));
        MetadataLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void catchingDebug(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.DEBUG, throwable, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return "Catching";
    }
}

