/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.util;

import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetServicesHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.PauseHandler;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ServiceUtil {
    public static ServiceInfo getServiceInfo(String service) {
        ServiceInfo si = GetServicesHandler.getServiceInfo(service);
        return si;
    }

    public static void pauseService(String service) throws BrokerException {
        PauseHandler.pauseService(true, service);
    }

    public static void resumeService(String service) throws BrokerException {
        PauseHandler.pauseService(false, service);
    }

    public static List getVisibleServiceNames() {
        List serviceNames = ServiceManager.getAllServiceNames();
        return serviceNames;
    }

    public static List getVisibleServices() {
        List serviceNames = ServiceUtil.getVisibleServiceNames();
        Iterator iter = serviceNames.iterator();
        ArrayList<ServiceInfo> al = new ArrayList<ServiceInfo>();
        while (iter.hasNext()) {
            String service = (String)iter.next();
            ServiceInfo sInfo = GetServicesHandler.getServiceInfo(service);
            al.add(sInfo);
        }
        return al;
    }

    public static int toExternalServiceState(int internalServiceState) {
        switch (internalServiceState) {
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 8: {
                return 2;
            }
        }
        return -1;
    }

    public static int toInternalServiceState(int externalServiceState) {
        switch (externalServiceState) {
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
        }
        return -1;
    }

    public static List getConsumerIDs(String service) {
        ArrayList consumerIDs = new ArrayList();
        List connections = ConnectionUtil.getConnectionInfoList(service);
        if (connections == null || connections.size() == 0) {
            return consumerIDs;
        }
        for (ConnectionInfo cxnInfo : connections) {
            long cxnID = cxnInfo.uuid;
            List oneCxnConsumerIDs = ConnectionUtil.getConsumerIDs(cxnID);
            consumerIDs.addAll(oneCxnConsumerIDs);
        }
        return consumerIDs;
    }

    public static List getProducerIDs(String service) {
        ArrayList producerIDs = new ArrayList();
        List connections = ConnectionUtil.getConnectionInfoList(service);
        if (connections == null || connections.size() == 0) {
            return producerIDs;
        }
        for (ConnectionInfo cxnInfo : connections) {
            long cxnID = cxnInfo.uuid;
            List oneCxnProducerIDs = ConnectionUtil.getProducerIDs(cxnID);
            producerIDs.addAll(oneCxnProducerIDs);
        }
        return producerIDs;
    }
}

