/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.injection;

import jakarta.jms.JMSConnectionFactory;
import jakarta.jms.JMSPasswordCredential;
import jakarta.jms.JMSSessionMode;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.internal.api.RelativePathResolver;

public class JMSContextMetadata
implements Serializable {
    static final SimpleJndiName DEFAULT_CONNECTION_FACTORY = new SimpleJndiName("java:comp/DefaultJMSConnectionFactory");
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger("jakarta.enterprise.resource.jms.injection");
    private final SimpleJndiName lookup;
    private final int sessionMode;
    private final String userName;
    private final String password;
    private String fingerPrint;

    JMSContextMetadata(JMSConnectionFactory jmsConnectionFactoryAnnot, JMSSessionMode sessionModeAnnot, JMSPasswordCredential credentialAnnot) {
        this.lookup = jmsConnectionFactoryAnnot == null ? null : new SimpleJndiName(jmsConnectionFactoryAnnot.value().trim());
        this.sessionMode = sessionModeAnnot == null ? 1 : sessionModeAnnot.value();
        if (credentialAnnot == null) {
            this.userName = null;
            this.password = null;
        } else {
            this.userName = credentialAnnot.userName();
            this.password = this.getUnAliasedPwd(credentialAnnot.password());
        }
    }

    public SimpleJndiName getLookup() {
        return this.lookup;
    }

    public int getSessionMode() {
        return this.sessionMode;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JMSContextMetadata[");
        sb.append("lookup=").append(this.lookup);
        sb.append(", sessionMode=").append(this.sessionMode);
        sb.append(", username=").append(this.userName);
        sb.append(", password=");
        if (this.password != null) {
            sb.append("xxxxxx");
        } else {
            sb.append("null");
        }
        sb.append(" [fingerPrint[").append(this.getFingerPrint());
        sb.append("]]");
        return sb.toString();
    }

    public String getFingerPrint() {
        if (this.fingerPrint == null) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte delimer = 124;
                messageDigest.update(delimer);
                SimpleJndiName cf = this.lookup;
                if (this.lookup == null) {
                    cf = DEFAULT_CONNECTION_FACTORY;
                }
                messageDigest.update(cf.toString().getBytes("ISO-8859-1"));
                messageDigest.update(delimer);
                messageDigest.update((byte)this.sessionMode);
                messageDigest.update(delimer);
                if (this.userName != null) {
                    messageDigest.update(this.userName.getBytes("ISO-8859-1"));
                }
                messageDigest.update(delimer);
                if (this.password != null) {
                    messageDigest.update(this.password.getBytes("ISO-8859-1"));
                }
                messageDigest.update(delimer);
                byte[] result = messageDigest.digest();
                StringBuilder buff = new StringBuilder();
                for (byte element : result) {
                    String byteStr = Integer.toHexString(element & 0xFF);
                    if (byteStr.length() < 2) {
                        buff.append('0');
                    }
                    buff.append(byteStr);
                }
                this.fingerPrint = buff.toString();
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't make digest of JMSContextMetadata content", e);
            }
        }
        return this.fingerPrint;
    }

    private boolean isPasswordAlias(String password) {
        return password != null && password.startsWith("${ALIAS=");
    }

    private String getUnAliasedPwd(String password) {
        if (password != null && this.isPasswordAlias(password)) {
            try {
                String unalisedPwd = RelativePathResolver.getRealPasswordFromAlias((String)password);
                if (unalisedPwd != null && !unalisedPwd.isEmpty()) {
                    return unalisedPwd;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to unalias password.", e);
            }
        }
        return password;
    }
}

