/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.admin.handlers;

import com.sun.messaging.bridge.admin.BridgeServiceManagerImpl;
import com.sun.messaging.bridge.admin.handlers.AdminCmdHandler;
import com.sun.messaging.bridge.admin.handlers.AdminMessageHandler;
import com.sun.messaging.bridge.admin.resources.BridgeManagerResources;
import com.sun.messaging.bridge.admin.util.AdminMessageType;
import com.sun.messaging.bridge.api.BridgeCmdSharedReplyData;
import com.sun.messaging.bridge.api.BridgeException;
import jakarta.jms.JMSException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import java.util.ArrayList;

public class ListHandler
extends AdminCmdHandler {
    public ListHandler(AdminMessageHandler parent, BridgeServiceManagerImpl bsm) {
        super(parent, bsm);
    }

    @Override
    public void handle(Session session, ObjectMessage msg, ObjectMessage reply, BridgeManagerResources bmr) throws BridgeException, JMSException, Exception {
        String[] stringArray;
        String lname;
        int msgtype = msg.getIntProperty("JMQMessageType");
        if (msgtype != 18) {
            throw new BridgeException(this._bmr.getKString("BB4013", AdminMessageType.getString(msgtype)));
        }
        String bnameval = msg.getStringProperty("JMQBridgeName");
        String btypeval = msg.getStringProperty("JMQBridgeType");
        String lnameval = msg.getStringProperty("JMQLinkName");
        boolean debugMode = msg.getBooleanProperty("JMQDebug");
        String bname = bnameval == null ? null : bnameval.trim();
        String btype = btypeval == null ? null : btypeval.trim().toUpperCase();
        String string = lname = lnameval == null ? null : lnameval.trim();
        if (bname != null && lname != null) {
            String[] stringArray2;
            if (bname.length() == 0) {
                throw new BridgeException(this._bmr.getKString("BB3009", bname));
            }
            if (lname.trim().length() == 0) {
                throw new BridgeException(this._bmr.getKString("BB3010", lname));
            }
            if (debugMode) {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "-ln";
                stringArray3[1] = lname;
                stringArray2 = stringArray3;
                stringArray3[2] = "-debug";
            } else {
                String[] stringArray4 = new String[2];
                stringArray4[0] = "-ln";
                stringArray2 = stringArray4;
                stringArray4[1] = lname;
            }
            String[] args = stringArray2;
            ArrayList<BridgeCmdSharedReplyData> data = this._bsm.listBridge(bname, args, btype, bmr);
            reply.setObject(data);
            this.parent.sendReply(session, msg, reply, 200, null, bmr);
            return;
        }
        if (lname != null && bname == null) {
            throw new BridgeException(this._bmr.getKString("BB3011"));
        }
        if (bname != null && bname.length() == 0) {
            throw new BridgeException(this._bmr.getKString("BB3009", bname));
        }
        if (debugMode) {
            String[] stringArray5 = new String[1];
            stringArray = stringArray5;
            stringArray5[0] = "-debug";
        } else {
            stringArray = null;
        }
        String[] args = stringArray;
        ArrayList<BridgeCmdSharedReplyData> data = this._bsm.listBridge(bname, args, btype, bmr);
        reply.setObject(data);
        this.parent.sendReply(session, msg, reply, 200, null, bmr);
    }
}

