/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.util.Arrays;
import org.junit.jupiter.api.condition.BooleanExecutionCondition;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.EnabledOnOsCondition;
import org.junit.jupiter.api.condition.OS;
import org.junit.platform.commons.util.Preconditions;

class DisabledOnOsCondition
extends BooleanExecutionCondition<DisabledOnOs> {
    DisabledOnOsCondition() {
        super(DisabledOnOs.class, EnabledOnOsCondition.ENABLED_ON_CURRENT_OS, EnabledOnOsCondition.DISABLED_ON_CURRENT_OS, DisabledOnOs::disabledReason);
    }

    @Override
    boolean isEnabled(DisabledOnOs annotation) {
        OS[] operatingSystems = annotation.value();
        Preconditions.condition((operatingSystems.length > 0 ? 1 : 0) != 0, (String)"You must declare at least one OS in @DisabledOnOs");
        return Arrays.stream(operatingSystems).noneMatch(OS::isCurrentOs);
    }
}

