/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.parameters.ui.contentassist;

import com.google.common.base.Objects;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.ui.contentassist.HtmlConfigurableCompletionProposal;
import org.eclipse.comma.parameters.ParametersUtils;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.parameters.ui.contentassist.AbstractParametersProposalProvider;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.ArrayExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ParametersProposalProvider
extends AbstractParametersProposalProvider {
    protected Image templateIcon = ImageDescriptor.createFromURL((URL)Platform.getBundle((String)"org.eclipse.comma.icons").getResource("icons/template.png")).createImage();
    private final int TEMPLATE_DEFAULT_PRIORITY = 600;

    @Override
    public void complete_TriggerParams(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _tripleNotEquals;
        super.complete_Parameters(model, ruleCall, context, acceptor);
        Parameters parameters = (Parameters)model;
        if (parameters.getInterface() == null || parameters.getInterface().getName() == null) {
            return;
        }
        Interface itf = parameters.getInterface();
        Object[] existingTriggerParams = new String[]{};
        EList _triggerParams = parameters.getTriggerParams();
        boolean bl = _tripleNotEquals = _triggerParams != null;
        if (_tripleNotEquals) {
            Functions.Function1 _function = t -> t.getEvent().getName();
            existingTriggerParams = (String[])Conversions.unwrapArray((Object)ListExtensions.map((List)parameters.getTriggerParams(), (Functions.Function1)_function), String.class);
        }
        String proposal = "";
        Map transitionStates = ParametersUtils.getTransitionStates((Interface)itf);
        Set _entrySet = transitionStates.entrySet();
        for (Map.Entry entry : _entrySet) {
            Functions.Function1 _function_1 = p -> {
                DIRECTION _direction = p.getDirection();
                return !Objects.equal((Object)_direction, (Object)DIRECTION.OUT);
            };
            Iterable params = IterableExtensions.filter((Iterable)((InterfaceEvent)entry.getKey()).getParameters(), (Functions.Function1)_function_1);
            if (ArrayExtensions.contains((Object[])existingTriggerParams, (Object)((InterfaceEvent)entry.getKey()).getName()) || IterableExtensions.isEmpty((Iterable)params)) continue;
            String _proposal = proposal;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("trigger: ");
            String _name = ((InterfaceEvent)entry.getKey()).getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
            Set _value = (Set)entry.getValue();
            for (String state : _value) {
                _builder.append("state: ");
                _builder.append(state);
                _builder.append(" params: ( ");
                Functions.Function1 _function_2 = p -> p.getName().toUpperCase();
                String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)params, (Functions.Function1)_function_2), (CharSequence)", ");
                _builder.append(_join);
                _builder.append(" )");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            proposal = String.valueOf(_proposal) + _builder;
        }
        acceptor.accept((ICompletionProposal)this.createProposal("Autocomplete missing triggers", proposal, "", context, 600 + 200, -1, -1));
    }

    @Override
    public void complete_NotificationParams(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _tripleNotEquals;
        super.complete_Parameters(model, ruleCall, context, acceptor);
        Parameters parameters = (Parameters)model;
        if (parameters.getInterface() == null || parameters.getInterface().getName() == null) {
            return;
        }
        Interface itf = parameters.getInterface();
        Object[] existingNotificationParams = new String[]{};
        EList _notificationParams = parameters.getNotificationParams();
        boolean bl = _tripleNotEquals = _notificationParams != null;
        if (_tripleNotEquals) {
            Functions.Function1 _function = t -> t.getEvent().getName();
            existingNotificationParams = (String[])Conversions.unwrapArray((Object)ListExtensions.map((List)parameters.getNotificationParams(), (Functions.Function1)_function), String.class);
        }
        String proposal = "";
        Map notificationStates = ParametersUtils.getUncoveredEventStates((Map)ParametersUtils.getUncoveredNotifications((Interface)itf, (Parameters)parameters));
        Set _entrySet = notificationStates.entrySet();
        for (Map.Entry entry : _entrySet) {
            boolean _not;
            boolean _contains = ArrayExtensions.contains((Object[])existingNotificationParams, (Object)((Notification)entry.getKey()).getName());
            boolean bl2 = _not = !_contains;
            if (!_not) continue;
            String _proposal = proposal;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("notification: ");
            String _name = ((Notification)entry.getKey()).getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
            List _value = (List)entry.getValue();
            for (String state : _value) {
                _builder.append("state: ");
                _builder.append(state);
                _builder.append(" params: ( ");
                Functions.Function1 _function_1 = p -> p.getName().toUpperCase();
                String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)((Notification)entry.getKey()).getParameters(), (Functions.Function1)_function_1), (CharSequence)", ");
                _builder.append(_join);
                _builder.append(" )");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            proposal = String.valueOf(_proposal) + _builder;
        }
        acceptor.accept((ICompletionProposal)this.createProposal("Autocomplete missing notifications", proposal, "", context, 600 + 100, -1, -1));
    }

    @Override
    public void complete_ReplyParams(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _tripleNotEquals;
        super.complete_Parameters(model, ruleCall, context, acceptor);
        Parameters parameters = (Parameters)model;
        if (parameters.getInterface() == null || parameters.getInterface().getName() == null) {
            return;
        }
        Interface itf = parameters.getInterface();
        Object[] existingReplyParams = new String[]{};
        EList _replyParams = parameters.getReplyParams();
        boolean bl = _tripleNotEquals = _replyParams != null;
        if (_tripleNotEquals) {
            Functions.Function1 _function = t -> t.getEvent().getName();
            existingReplyParams = (String[])Conversions.unwrapArray((Object)ListExtensions.map((List)parameters.getReplyParams(), (Functions.Function1)_function), String.class);
        }
        String proposal = "";
        Map replyStates = ParametersUtils.getUncoveredEventStates((Map)ParametersUtils.getUncoveredReplies((Interface)itf, (Parameters)parameters));
        Set _entrySet = replyStates.entrySet();
        for (Map.Entry entry : _entrySet) {
            boolean _not;
            Functions.Function1 _function_1 = p -> {
                DIRECTION _direction = p.getDirection();
                return _direction != DIRECTION.IN;
            };
            Iterable params = IterableExtensions.filter((Iterable)((Command)entry.getKey()).getParameters(), (Functions.Function1)_function_1);
            boolean _contains = ArrayExtensions.contains((Object[])existingReplyParams, (Object)((Command)entry.getKey()).getName());
            boolean bl2 = _not = !_contains;
            if (!_not) continue;
            String _proposal = proposal;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("reply to: ");
            String _name = ((Command)entry.getKey()).getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
            List _value = (List)entry.getValue();
            for (String state : _value) {
                boolean _not_1;
                _builder.append("state: ");
                _builder.append(state);
                _builder.append(" params: ( ");
                Functions.Function1 _function_2 = p -> p.getName().toUpperCase();
                String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)params, (Functions.Function1)_function_2), (CharSequence)", ");
                _builder.append(_join);
                Command _key = (Command)entry.getKey();
                boolean _isVoid = TypeUtilities.isVoid((Type)_key.getType());
                boolean bl3 = _not_1 = !_isVoid;
                if (_not_1) {
                    boolean _not_2;
                    boolean _isEmpty = IterableExtensions.isEmpty((Iterable)params);
                    boolean bl4 = _not_2 = !_isEmpty;
                    if (_not_2) {
                        _builder.append(", ");
                    }
                    _builder.append("RETURN_VALUE");
                }
                _builder.append(" )");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            proposal = String.valueOf(_proposal) + _builder;
        }
        acceptor.accept((ICompletionProposal)this.createProposal("Autocomplete missing replies", proposal, "", context, 600, -1, -1));
    }

    private HtmlConfigurableCompletionProposal createProposal(String name, String content, String additionalInfo, ContentAssistContext context, int priority, int selection, int length) {
        HtmlConfigurableCompletionProposal _xblockexpression = null;
        String finalAdditionalInfo = content;
        StyledString _styledString = new StyledString(name);
        HtmlConfigurableCompletionProposal proposal = this.createHtmlCompletionProposal(content, _styledString, this.templateIcon, 600, context);
        if (proposal instanceof ConfigurableCompletionProposal) {
            while (finalAdditionalInfo.startsWith("\n") || finalAdditionalInfo.startsWith("\r")) {
                finalAdditionalInfo = finalAdditionalInfo.substring(1);
            }
            finalAdditionalInfo = "<html><body bgcolor=\"#FFFFE1\"><style> body { font-size:9pt; font-family:'Segoe UI' }</style><pre>" + finalAdditionalInfo + "</pre>";
            if (additionalInfo != null) {
                finalAdditionalInfo = String.valueOf(finalAdditionalInfo) + "<p>" + additionalInfo + "</p>";
            }
            finalAdditionalInfo = String.valueOf(finalAdditionalInfo) + "</body></html>";
            proposal.setAdditionalProposalInfo((Object)finalAdditionalInfo);
            proposal.setProposalContextResource((Resource)context.getResource());
            proposal.setPriority(priority);
            int _offset = context.getOffset();
            int _plus = _offset + selection;
            proposal.setSelectionStart(_plus);
            proposal.setSelectionLength(length);
        }
        _xblockexpression = proposal;
        return _xblockexpression;
    }

    private HtmlConfigurableCompletionProposal createHtmlCompletionProposal(String proposal, StyledString displayString, Image image, int priority, ContentAssistContext context) {
        boolean _isValidProposal = this.isValidProposal(proposal, context.getPrefix(), context);
        if (_isValidProposal) {
            return this.doCreateHtmlCompletionProposal(proposal, displayString, image, priority, context);
        }
        return null;
    }

    private HtmlConfigurableCompletionProposal doCreateHtmlCompletionProposal(String proposal, StyledString displayString, Image image, int priority, ContentAssistContext context) {
        HtmlConfigurableCompletionProposal _xblockexpression = null;
        int replacementOffset = context.getReplaceRegion().getOffset();
        int replacementLength = context.getReplaceRegion().getLength();
        int _length = proposal.length();
        HtmlConfigurableCompletionProposal result = new HtmlConfigurableCompletionProposal(proposal, replacementOffset, replacementLength, _length, image, displayString, null, null);
        result.setPriority(priority);
        result.setMatcher(context.getMatcher());
        result.setReplaceContextLength(context.getReplaceContextLength());
        _xblockexpression = result;
        return _xblockexpression;
    }
}

