/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jdt;

import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.plantuml.jdt.JdtDiagramTextProvider;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;

public class JavaViewDiagramTextProvider
extends JdtDiagramTextProvider {
    public JavaViewDiagramTextProvider() {
        this.setViewType(IViewPart.class);
    }

    public String getDiagramText(IViewPart viewPart, ISelection selection) {
        Collection<IType> javaElements = this.getSelectedTypes(selection);
        StringBuilder result = new StringBuilder();
        for (IType javaElement : javaElements) {
            this.generateForType(javaElement, result, javaElements);
        }
        return result.length() > 0 ? this.ensureDiagramText(result.toString()) : null;
    }

    @Override
    public boolean supportsSelection(ISelection selection) {
        Collection<IType> selectedTypes = this.getSelectedTypes(selection);
        return selectedTypes != null && !selectedTypes.isEmpty();
    }

    protected Collection<IType> getSelectedTypes(ISelection selection) {
        ArrayList<IType> javaElements = new ArrayList<IType>();
        if (selection instanceof IStructuredSelection) {
            for (Object next : (IStructuredSelection)selection) {
                if (!(next instanceof IJavaElement)) continue;
                this.addJavaElements((IJavaElement)next, javaElements);
            }
        }
        return javaElements;
    }

    protected void addJavaElements(IJavaElement javaElement, Collection<IType> javaElements) {
        if (javaElement instanceof ICompilationUnit) {
            try {
                IType[] types = ((ICompilationUnit)javaElement).getTypes();
                if (types != null && types.length > 0) {
                    javaElements.add(types[0]);
                }
            }
            catch (JavaModelException types) {}
        } else if (javaElement instanceof IPackageFragment) {
            try {
                ICompilationUnit[] iCompilationUnitArray = ((IPackageFragment)javaElement).getCompilationUnits();
                int n = iCompilationUnitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompilationUnit compUnit = iCompilationUnitArray[n2];
                    this.addJavaElements((IJavaElement)compUnit, javaElements);
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        } else if (javaElement instanceof IType) {
            javaElements.add((IType)javaElement);
        }
    }
}

