/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.validation.type;

import java.util.Set;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.validation.type.AbstractType;
import org.eclipse.acceleo.query.validation.type.IJavaType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;

public class EClassifierType
extends AbstractType {
    private final EClassifier type;
    private final IReadOnlyQueryEnvironment queryEnvironment;

    public EClassifierType(IReadOnlyQueryEnvironment queryEnvironment, EClassifier type) {
        this.queryEnvironment = queryEnvironment;
        this.type = type;
    }

    public EClassifier getType() {
        return this.type;
    }

    @Override
    public boolean isAssignableFrom(IType otherType) {
        boolean result = !this.queryEnvironment.getEPackageProvider().isRegistered(this.type) ? false : (this.getType() instanceof EClass ? (otherType.getType() instanceof EClass ? this.getType() == otherType.getType() || this.getType() == EcorePackage.eINSTANCE.getEObject() || this.queryEnvironment.getEPackageProvider().getAllSubTypes((EClass)this.getType()).contains(otherType.getType()) : (otherType.getType() instanceof Class ? this.emfIsAssignableFrom(otherType) : this.javaIsAssignableFrom(otherType))) : this.javaIsAssignableFrom(otherType));
        return result;
    }

    private boolean emfIsAssignableFrom(IType otherType) {
        boolean result;
        Set<EClassifier> eClasses = this.queryEnvironment.getEPackageProvider().getEClassifiers((Class)otherType.getType());
        if (eClasses != null) {
            boolean compatible = false;
            for (EClassifier eCls : eClasses) {
                if (this.getType() != eCls && this.getType() != EcorePackage.eINSTANCE.getEObject() && !this.queryEnvironment.getEPackageProvider().getAllSubTypes((EClass)this.getType()).contains(eCls)) continue;
                compatible = true;
                break;
            }
            result = compatible;
        } else {
            result = this.javaIsAssignableFrom(otherType);
        }
        return result;
    }

    private boolean javaIsAssignableFrom(IType otherType) {
        Class<?> ourClass = this.queryEnvironment.getEPackageProvider().getClass(this.getType());
        Class<?> otherClass = otherType instanceof EClassifierType ? this.queryEnvironment.getEPackageProvider().getClass(((EClassifierType)otherType).getType()) : (otherType instanceof IJavaType ? ((IJavaType)otherType).getType() : null);
        boolean result = this.isAssignableFrom(ourClass, otherClass);
        return result;
    }

    public String toString() {
        return "EClassifier=" + this.type.getName();
    }
}

