/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.AlarmConditionTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.LimitAlarmType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class LimitAlarmTypeNode
extends AlarmConditionTypeNode
implements LimitAlarmType {
    public LimitAlarmTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public Double getHighHighLimit() throws UaException {
        PropertyTypeNode node = this.getHighHighLimitNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setHighHighLimit(Double highHighLimit) throws UaException {
        PropertyTypeNode node = this.getHighHighLimitNode();
        node.setValue(new Variant((Object)highHighLimit));
    }

    @Override
    public Double readHighHighLimit() throws UaException {
        try {
            return this.readHighHighLimitAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeHighHighLimit(Double highHighLimit) throws UaException {
        try {
            this.writeHighHighLimitAsync(highHighLimit).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readHighHighLimitAsync() {
        return ((CompletableFuture)this.getHighHighLimitNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeHighHighLimitAsync(Double highHighLimit) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)highHighLimit));
        return this.getHighHighLimitNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getHighHighLimitNode() throws UaException {
        try {
            return this.getHighHighLimitNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getHighHighLimitNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HighHighLimit", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getHighLimit() throws UaException {
        PropertyTypeNode node = this.getHighLimitNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setHighLimit(Double highLimit) throws UaException {
        PropertyTypeNode node = this.getHighLimitNode();
        node.setValue(new Variant((Object)highLimit));
    }

    @Override
    public Double readHighLimit() throws UaException {
        try {
            return this.readHighLimitAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeHighLimit(Double highLimit) throws UaException {
        try {
            this.writeHighLimitAsync(highLimit).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readHighLimitAsync() {
        return ((CompletableFuture)this.getHighLimitNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeHighLimitAsync(Double highLimit) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)highLimit));
        return this.getHighLimitNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getHighLimitNode() throws UaException {
        try {
            return this.getHighLimitNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getHighLimitNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HighLimit", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getLowLimit() throws UaException {
        PropertyTypeNode node = this.getLowLimitNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setLowLimit(Double lowLimit) throws UaException {
        PropertyTypeNode node = this.getLowLimitNode();
        node.setValue(new Variant((Object)lowLimit));
    }

    @Override
    public Double readLowLimit() throws UaException {
        try {
            return this.readLowLimitAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLowLimit(Double lowLimit) throws UaException {
        try {
            this.writeLowLimitAsync(lowLimit).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readLowLimitAsync() {
        return ((CompletableFuture)this.getLowLimitNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLowLimitAsync(Double lowLimit) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lowLimit));
        return this.getLowLimitNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getLowLimitNode() throws UaException {
        try {
            return this.getLowLimitNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLowLimitNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LowLimit", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getLowLowLimit() throws UaException {
        PropertyTypeNode node = this.getLowLowLimitNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setLowLowLimit(Double lowLowLimit) throws UaException {
        PropertyTypeNode node = this.getLowLowLimitNode();
        node.setValue(new Variant((Object)lowLowLimit));
    }

    @Override
    public Double readLowLowLimit() throws UaException {
        try {
            return this.readLowLowLimitAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLowLowLimit(Double lowLowLimit) throws UaException {
        try {
            this.writeLowLowLimitAsync(lowLowLimit).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readLowLowLimitAsync() {
        return ((CompletableFuture)this.getLowLowLimitNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLowLowLimitAsync(Double lowLowLimit) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lowLowLimit));
        return this.getLowLowLimitNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getLowLowLimitNode() throws UaException {
        try {
            return this.getLowLowLimitNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLowLowLimitNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LowLowLimit", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

