/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.ConnectionHelper;
import org.eclipse.fordiac.ide.model.dataimport.SubAppNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

class ResDevFBNetworkImporter
extends SubAppNetworkImporter {
    private final EList<VarDeclaration> varInputs;
    private final List<ConnectionHelper.ConnectionBuilder<Connection>> brokenConnections = new ArrayList<ConnectionHelper.ConnectionBuilder<Connection>>();

    ResDevFBNetworkImporter(CommonElementImporter importer, EList<VarDeclaration> varInputs) {
        super(importer);
        this.varInputs = varInputs;
    }

    ResDevFBNetworkImporter(CommonElementImporter importer, FBNetwork fbNetwork, EList<VarDeclaration> varInputs, Map<String, FBNetworkElement> fbNetworkElementMap) {
        super(importer, fbNetwork, fbNetworkElementMap);
        this.varInputs = varInputs;
    }

    public List<ConnectionHelper.ConnectionBuilder<Connection>> getBrokenConnections() {
        return this.brokenConnections;
    }

    @Override
    IInterfaceElement getContainingInterfaceElement(String interfaceElement, EClass conType, boolean isInput) {
        for (VarDeclaration inVar : this.varInputs) {
            if (!inVar.getName().equals(interfaceElement)) continue;
            return inVar;
        }
        return null;
    }

    @Override
    protected void addFBNetworkElement(FBNetworkElement element) {
        String name = element.getName();
        int separator = name.lastIndexOf(46);
        if (separator != -1) {
            name = name.substring(separator + 1);
        }
        super.addFBNetworkElement(element);
        element.setName(name);
    }

    @Override
    protected <T extends Connection> T parseConnection(EClass conType) throws XMLStreamException, TypeImportException {
        ConnectionHelper.ConnectionBuilder builder = ConnectionHelper.createConnectionBuilder(conType, this);
        builder.validate();
        if (builder.isMissingConnectionDestination() || builder.isMissingConnectionSource()) {
            this.brokenConnections.add(builder);
            return null;
        }
        builder.handleErrorCases();
        return builder.getConnection();
    }
}

