/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.fordiac.ide.model.ConnectionLayoutTagger;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.commands.Command;

public class ToggleSubAppRepresentationCommand
extends Command
implements ConnectionLayoutTagger {
    private final SubApp subapp;
    private String oldAttribute;
    private String newAttribute;

    public ToggleSubAppRepresentationCommand(SubApp subapp) {
        this.subapp = subapp;
    }

    public void execute() {
        this.oldAttribute = this.subapp.getAttributeValue("Unfolded");
        this.newAttribute = this.subapp.isUnfolded() ? null : "true";
        this.setRepresentationAttribute(this.newAttribute);
    }

    public void undo() {
        this.setRepresentationAttribute(this.oldAttribute);
    }

    public void redo() {
        this.setRepresentationAttribute(this.newAttribute);
    }

    private void setRepresentationAttribute(String text) {
        if (text == null) {
            this.subapp.deleteAttribute("Unfolded");
        } else {
            this.subapp.setAttribute(InternalAttributeDeclarations.UNFOLDED, text, "");
        }
    }
}

