/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.variable;

import java.util.Objects;
import org.eclipse.fordiac.ide.model.data.AnyElementaryType;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.eval.value.AnyElementaryValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.AbstractVariable;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;

public final class ElementaryVariable<T extends AnyElementaryValue>
extends AbstractVariable<T> {
    private T value;

    public ElementaryVariable(String name, AnyElementaryType type) {
        this(name, type, ValueOperations.defaultValue((LibraryElement)type));
    }

    public ElementaryVariable(String name, AnyElementaryType type, String value) {
        super(name, (LibraryElement)type);
        this.setValue(value);
    }

    public ElementaryVariable(String name, AnyElementaryType type, Value value) {
        super(name, (LibraryElement)type);
        this.setValue(value);
    }

    @Override
    public void setValue(Value value) {
        Objects.requireNonNull(value);
        this.value = (AnyElementaryValue)ValueOperations.castValue(value, (LibraryElement)this.getType());
    }

    public AnyType getType() {
        return (AnyType)super.getType();
    }

    @Override
    public T getValue() {
        return this.value;
    }
}

