/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.actions.CopyPasteData;
import org.eclipse.fordiac.ide.application.commands.ConnectionReference;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.ui.FordiacClipboard;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CopyEditPartsAction
extends SelectionAction {
    public CopyEditPartsAction(IEditorPart editor) {
        super((IWorkbenchPart)editor);
        this.setId(ActionFactory.COPY.getId());
        this.setText(Messages.CopyEditPartsAction_Text);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
    }

    protected boolean calculateEnabled() {
        for (Object obj : this.getSelectedObjects()) {
            EditPart ep;
            if (!(obj instanceof EditPart) || !((ep = (EditPart)obj).getModel() instanceof FBNetworkElement)) continue;
            return true;
        }
        return false;
    }

    public void run() {
        FordiacClipboard.INSTANCE.setGraphicalContents((Object)this.getSelectedTemplates());
    }

    protected CopyPasteData getSelectedTemplates() {
        CopyPasteData copyPasteData = new CopyPasteData((FBNetwork)this.getWorkbenchPart().getAdapter(FBNetwork.class));
        HashSet<Connection> connectionSet = new HashSet<Connection>();
        for (Object obj : this.getSelectedObjects()) {
            EditPart ep;
            Object object;
            if (!(obj instanceof EditPart) || !((object = (ep = (EditPart)obj).getModel()) instanceof FBNetworkElement)) continue;
            FBNetworkElement fbne = (FBNetworkElement)object;
            copyPasteData.elements().add(fbne);
            if (fbne instanceof BlockFBNetworkElement) {
                BlockFBNetworkElement bfbne = (BlockFBNetworkElement)fbne;
                copyPasteData.conns().addAll(CopyEditPartsAction.getAllFBNElementConnections(bfbne, connectionSet));
            }
            if (!(fbne instanceof Group)) continue;
            Group group = (Group)fbne;
            FBNetworkHelper.getBlockFBNetworkElementsFromList((Collection)group.getGroupElements()).forEach(groupElement -> {
                boolean bl = copyPasteData.conns().addAll(CopyEditPartsAction.getAllFBNElementConnections(groupElement, connectionSet));
            });
        }
        CopyEditPartsAction.removeDuplicateElements(copyPasteData);
        return copyPasteData;
    }

    private static void removeDuplicateElements(CopyPasteData copyPasteData) {
        copyPasteData.elements().removeIf(element -> copyPasteData.elements().stream().filter(SubApp.class::isInstance).map(SubApp.class::cast).filter(subapp -> !subapp.isTyped()).anyMatch(subapp -> subapp.getSubAppNetwork().getNetworkElements().contains(element)));
        copyPasteData.elements().removeIf(element -> copyPasteData.elements().stream().filter(Group.class::isInstance).map(Group.class::cast).anyMatch(group -> group.getGroupElements().contains(element)));
    }

    private static Collection<ConnectionReference> getAllFBNElementConnections(BlockFBNetworkElement model, Set<Connection> connectionSet) {
        ArrayList<ConnectionReference> connections = new ArrayList<ConnectionReference>();
        for (IInterfaceElement elem : model.getInterface().getAllInterfaceElements()) {
            CopyEditPartsAction.getConnectionList(elem).stream().filter(conn -> !connectionSet.contains(conn)).forEach(conn -> {
                connectionSet.add((Connection)conn);
                connections.add(new ConnectionReference((Connection)conn));
            });
        }
        return connections;
    }

    private static EList<Connection> getConnectionList(IInterfaceElement elem) {
        return elem.isIsInput() ? elem.getInputConnections() : elem.getOutputConnections();
    }
}

