/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.value.AbstractStringValueConverter;

public final class StringValueConverter
extends AbstractStringValueConverter {
    public static final StringValueConverter INSTANCE = new StringValueConverter();

    private StringValueConverter() {
    }

    @Override
    public String toValue(String string) throws IllegalArgumentException {
        if (string.isEmpty() || string.charAt(0) != '\'') {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalStringLiteral, string));
        }
        return super.toValue(string);
    }

    @Override
    public String toValue(Scanner scanner) throws IllegalArgumentException, NoSuchElementException, IllegalStateException {
        if (scanner.findWithinHorizon(SCANNER_STRING_QUOTE_PATTERN, 0) == null) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalStringLiteral, "<scanner>"));
        }
        return StringValueConverter.toValue(scanner, SCANNER_STRING_QUOTE_PATTERN, SCANNER_STRING_ESCAPE_PATTERN, SCANNER_STRING_NON_ESCAPE_PATTERN);
    }

    @Override
    public String toString(String value) {
        return StringValueConverter.toString(value, false);
    }
}

