/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection.event;

import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.ISelectionEvent;

public class CellSelectionEvent
extends CellVisualChangeEvent
implements ISelectionEvent {
    private final SelectionLayer selectionLayer;
    private boolean withShiftMask = false;
    private boolean withControlMask = false;
    private boolean forcingEntireCellIntoViewport = true;

    public CellSelectionEvent(SelectionLayer selectionLayer, int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask) {
        super(selectionLayer, columnPosition, rowPosition);
        this.selectionLayer = selectionLayer;
        this.withControlMask = withControlMask;
        this.withShiftMask = withShiftMask;
    }

    public CellSelectionEvent(SelectionLayer selectionLayer, int columnPosition, int rowPosition, boolean withShiftMask, boolean withControlMask, boolean forcingEntireCellIntoViewport) {
        super(selectionLayer, columnPosition, rowPosition);
        this.selectionLayer = selectionLayer;
        this.withControlMask = withControlMask;
        this.withShiftMask = withShiftMask;
        this.forcingEntireCellIntoViewport = forcingEntireCellIntoViewport;
    }

    protected CellSelectionEvent(CellSelectionEvent event) {
        super(event);
        this.selectionLayer = event.selectionLayer;
        this.withControlMask = event.withControlMask;
        this.withShiftMask = event.withShiftMask;
        this.forcingEntireCellIntoViewport = event.forcingEntireCellIntoViewport;
    }

    @Override
    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    @Override
    public CellSelectionEvent cloneEvent() {
        return new CellSelectionEvent(this);
    }

    public boolean isWithShiftMask() {
        return this.withShiftMask;
    }

    public boolean isWithControlMask() {
        return this.withControlMask;
    }

    public boolean isForcingEntireCellIntoViewport() {
        return this.forcingEntireCellIntoViewport;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        if (this.columnPosition == -1 || this.rowPosition == -1) {
            return true;
        }
        this.columnPosition = localLayer.underlyingToLocalColumnPosition(this.getLayer(), this.columnPosition);
        this.rowPosition = localLayer.underlyingToLocalRowPosition(this.getLayer(), this.rowPosition);
        this.layer = localLayer;
        return this.columnPosition >= 0 && this.rowPosition >= 0 && this.columnPosition < this.layer.getColumnCount() && this.rowPosition < this.layer.getRowCount();
    }
}

